/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.admin.api.search.ISearchService;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.search.beans.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.beans.MediaTypeValueList;
import org.wso2.carbon.registry.search.beans.SearchResultsBean;
import org.wso2.carbon.registry.search.internal.SearchDataHolder;
import org.wso2.carbon.registry.search.services.utils.AdvancedSearchFilterActions;
import org.wso2.carbon.registry.search.services.utils.CustomSearchParameterPopulator;
import org.wso2.carbon.registry.search.services.utils.SearchResultsBeanPopulator;
import org.wso2.carbon.registry.search.services.utils.SearchUtils;

public class SearchService
extends RegistryAbstractAdmin
implements ISearchService<SearchResultsBean, AdvancedSearchResultsBean, CustomSearchParameterBean, MediaTypeValueList> {
    private boolean allEmpty = true;
    private static final String SEARCH_ATTRIBUTES_ALL_EMPTY_MESSAGE = "At least one field must be filled";
    private static final String SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE = " contains illegal characters";

    public SearchResultsBean getSearchResults(String searchType, String criteria) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{searchType, criteria});
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return SearchResultsBeanPopulator.populate(registry, searchType, criteria);
    }

    public AdvancedSearchResultsBean getAdvancedSearchResults(CustomSearchParameterBean parameters) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{parameters});
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        AttributeSearchService attributeSearchService = SearchDataHolder.getInstance().getAttributeIndexingService();
        String[][] searchParameterValues = parameters.getParameterValues();
        ResourceData[] advanceSearchResourceData = new ResourceData[]{};
        String validationErrorMessage = this.getValidationErrorMessage(searchParameterValues);
        if (validationErrorMessage != null && StringUtils.isNotEmpty((String)validationErrorMessage)) {
            return SearchUtils.getEmptyResultBeanWithErrorMsg(validationErrorMessage);
        }
        if (this.allEmpty) {
            return SearchUtils.getEmptyResultBeanWithErrorMsg(SEARCH_ATTRIBUTES_ALL_EMPTY_MESSAGE);
        }
        Map<String, String> advanceSearchAttributes = this.getAdvanceSearchValueMap(searchParameterValues);
        if (!(attributeSearchService == null || advanceSearchAttributes.size() <= 0 || advanceSearchAttributes.size() == 2 && advanceSearchAttributes.containsKey("leftOp") && advanceSearchAttributes.get("leftOp").equals("na") && advanceSearchAttributes.containsKey("rightOp") && advanceSearchAttributes.get("rightOp").equals("na"))) {
            advanceSearchAttributes.put("AdvanceSearch", "true");
            advanceSearchResourceData = (ResourceData[])attributeSearchService.search(registry, advanceSearchAttributes);
        }
        AdvancedSearchResultsBean advancedSearchResultsBean = new AdvancedSearchResultsBean();
        if (advanceSearchResourceData != null && advanceSearchResourceData.length > 0) {
            advanceSearchResourceData = this.getSortedSearchResults(advanceSearchResourceData);
            advancedSearchResultsBean.setResourceDataList(advanceSearchResourceData);
            if (!this.isEmptyResourceDataList(advancedSearchResultsBean)) {
                return this.getPaginatedResult(advancedSearchResultsBean);
            }
        }
        advancedSearchResultsBean.setResourceDataList(new ResourceData[0]);
        return advancedSearchResultsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceData[] getSortedSearchResults(ResourceData[] results) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext)) {
            String createdDate = "created";
            String author = "author";
            String rating = "rating";
            try {
                PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                String sortOrder = paginationContext.getSortOrder();
                String sortBy = paginationContext.getSortBy();
                if (sortBy != null && sortOrder != null) {
                    if (createdDate.equals(sortBy)) {
                        this.sortReultsOnCreatedDate(results, sortOrder);
                    } else if (author.equals(sortBy)) {
                        this.sortResultsOnAuthor(results, sortOrder);
                    } else if (rating.equals(sortBy)) {
                        this.sortResultsOnrating(results, sortOrder);
                    }
                }
            }
            finally {
                PaginationContext.destroy();
            }
            return results;
        }
        return results;
    }

    private ResourceData[] sortReultsOnCreatedDate(ResourceData[] results, final String sortOrder) {
        String sortCriteria = "ASC";
        Arrays.sort(results, new Comparator<ResourceData>(){

            @Override
            public int compare(ResourceData o1, ResourceData o2) {
                if ("ASC".equals(sortOrder)) {
                    return o1.getCreatedOn().compareTo(o2.getCreatedOn());
                }
                return o2.getCreatedOn().compareTo(o1.getCreatedOn());
            }
        });
        return results;
    }

    private ResourceData[] sortResultsOnAuthor(ResourceData[] results, final String sortOrder) {
        String sortCriteria = "ASC";
        Arrays.sort(results, new Comparator<ResourceData>(){

            @Override
            public int compare(ResourceData o1, ResourceData o2) {
                if ("ASC".equals(sortOrder)) {
                    return o1.getAuthorUserName().compareTo(o2.getAuthorUserName());
                }
                return o2.getAuthorUserName().compareTo(o1.getAuthorUserName());
            }
        });
        return results;
    }

    private ResourceData[] sortResultsOnrating(ResourceData[] results, final String sortOrder) {
        String sortCriteria = "ASC";
        Arrays.sort(results, new Comparator<ResourceData>(){

            @Override
            public int compare(ResourceData o1, ResourceData o2) {
                Float rating1 = Float.valueOf(o1.getAverageRating());
                Float rating2 = Float.valueOf(o2.getAverageRating());
                if ("ASC".equals(sortOrder)) {
                    return rating1.compareTo(rating2);
                }
                return rating2.compareTo(rating1);
            }
        });
        return results;
    }

    private boolean isEmptyResourceDataList(AdvancedSearchResultsBean resultsBean) {
        boolean resultEmpty = true;
        if (resultsBean.getResourceDataList() != null && resultsBean.getResourceDataList().length > 0) {
            for (ResourceData data : resultsBean.getResourceDataList()) {
                if (data == null) continue;
                resultEmpty = false;
                break;
            }
        }
        return resultEmpty;
    }

    private String getValidationErrorMessage(String[][] searchParameterValues) {
        String message = null;
        for (String[] tempParameterValue : searchParameterValues) {
            if (!(tempParameterValue[1] != null & tempParameterValue[1].trim().length() > 0)) continue;
            this.allEmpty = false;
            if (tempParameterValue[0].equals("createdAfter") || tempParameterValue[0].equals("createdBefore") || tempParameterValue[0].equals("updatedAfter") || tempParameterValue[0].equals("updatedBefore")) {
                if (SearchUtils.validateDateInput(tempParameterValue[1])) continue;
                message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
                continue;
            }
            if (tempParameterValue[0].equals("author")) {
                if (!SearchUtils.validatePathInput(tempParameterValue[1])) continue;
                message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
                continue;
            }
            if (tempParameterValue[0].equals("mediaType")) {
                if (!SearchUtils.validateMediaTypeInput(tempParameterValue[1])) continue;
                message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
                continue;
            }
            if (tempParameterValue[0].equals("content")) {
                if (!SearchUtils.validateContentInput(tempParameterValue[1])) continue;
                message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
                continue;
            }
            if (tempParameterValue[0].equals("tags")) {
                boolean containsTag = false;
                for (String str : tempParameterValue[1].split(",")) {
                    if (str.trim().length() <= 0) continue;
                    containsTag = true;
                    break;
                }
                if (!containsTag) {
                    message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
                }
                if (!SearchUtils.validateTagsInput(tempParameterValue[1])) continue;
                message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
                continue;
            }
            if (!SearchUtils.validatePathInput(tempParameterValue[1])) continue;
            message = tempParameterValue[0] + SEARCH_ATTRIBUTES_CONTAINS_ILLEGAL_CHARACTER_MESSAGE;
        }
        return message;
    }

    private Map<String, String> getAdvanceSearchValueMap(String[][] searchParameterValues) {
        HashMap<String, String> advanceSearchAttributes = new HashMap<String, String>();
        for (String[] tempParameterValue : searchParameterValues) {
            if (tempParameterValue[0].equals("content") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("content", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("mediaType") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("mediaType", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("resourcePath") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                if (tempParameterValue[1].length() == 1 && tempParameterValue[1].charAt(0) == '%') continue;
                advanceSearchAttributes.put("resourceName", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("author") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                if (tempParameterValue[1].length() == 1 && tempParameterValue[1].charAt(0) == '%') continue;
                advanceSearchAttributes.put("author", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("updater") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                if (tempParameterValue[1].length() == 1 && tempParameterValue[1].charAt(0) == '%') continue;
                advanceSearchAttributes.put("updater", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("createdAfter") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("createdAfter", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("createdBefore") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("createdBefore", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("updatedAfter") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("updatedAfter", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("updatedBefore") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("updatedBefore", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("tags") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("tags", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("commentWords") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("commentWords", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("associationType") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("associationType", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("associationDest") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("associationDest", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("authorNameNegate") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("authorNameNegate", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("updaterNameNegate") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("updaterNameNegate", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("createdRangeNegate") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("createdRangeNegate", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("updatedRangeNegate") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("updatedRangeNegate", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("mediaTypeNegate") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("mediaTypeNegate", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("propertyName") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("propertyName", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("leftPropertyValue") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                if (tempParameterValue[1].length() == 1 && tempParameterValue[1].charAt(0) == '%') continue;
                advanceSearchAttributes.put("leftPropertyValue", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("rightPropertyValue") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                if (tempParameterValue[1].length() == 1 && tempParameterValue[1].charAt(0) == '%') continue;
                advanceSearchAttributes.put("rightPropertyValue", tempParameterValue[1]);
                continue;
            }
            if (tempParameterValue[0].equals("leftOp") && tempParameterValue[1] != null && !StringUtils.isEmpty((String)tempParameterValue[1])) {
                advanceSearchAttributes.put("leftOp", tempParameterValue[1]);
                continue;
            }
            if (!tempParameterValue[0].equals("rightOp") || tempParameterValue[1] == null || StringUtils.isEmpty((String)tempParameterValue[1])) continue;
            advanceSearchAttributes.put("rightOp", tempParameterValue[1]);
        }
        return advanceSearchAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdvancedSearchResultsBean getPaginatedResult(AdvancedSearchResultsBean advancedSearchResultsBean) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext) && advancedSearchResultsBean.getResourceDataList() != null) {
            int rowCount = advancedSearchResultsBean.getResourceDataList().length;
            try {
                ResourceData[] paginatedResult;
                PaginationUtils.setRowCount((MessageContext)messageContext, (String)Integer.toString(rowCount));
                PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedResult = new ResourceData[rowCount - startIndex];
                    System.arraycopy(advancedSearchResultsBean.getResourceDataList(), startIndex, paginatedResult, 0, rowCount - startIndex);
                } else {
                    paginatedResult = new ResourceData[count];
                    System.arraycopy(advancedSearchResultsBean.getResourceDataList(), startIndex, paginatedResult, 0, count);
                }
                advancedSearchResultsBean.setResourceDataList(paginatedResult);
                AdvancedSearchResultsBean advancedSearchResultsBean2 = advancedSearchResultsBean;
                return advancedSearchResultsBean2;
            }
            finally {
                PaginationContext.destroy();
            }
        }
        return advancedSearchResultsBean;
    }

    public MediaTypeValueList getMediaTypeSearch(String mediaType) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return CustomSearchParameterPopulator.getMediaTypeParameterValues(registry, mediaType);
    }

    public void saveAdvancedSearchFilter(CustomSearchParameterBean queryBean, String filterName) throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        AdvancedSearchFilterActions.saveAdvancedSearchQueryBean(configUserRegistry, queryBean, filterName);
    }

    public CustomSearchParameterBean getAdvancedSearchFilter(String filterName) throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        return AdvancedSearchFilterActions.getAdvancedSearchQueryBean(configUserRegistry, filterName);
    }

    public String[] getSavedFilters() throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        return AdvancedSearchFilterActions.getSavedFilterNames(configUserRegistry);
    }

    public void deleteFilter(String filterName) throws RegistryException {
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        configUserRegistry.delete("/users/" + CarbonContext.getThreadLocalCarbonContext().getUsername() + "/" + "searchFilters" + "/" + filterName);
    }
}

