/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.internal;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.common.AttributeSearchService;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.queries.QueryProcessorManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.search.beans.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.internal.SearchDataHolder;
import org.wso2.carbon.registry.search.services.MetadataSearchService;
import org.wso2.carbon.registry.search.services.XPathQueryProcessor;
import org.wso2.carbon.registry.search.services.utils.AdvancedSearchResultsBeanPopulator;

@Component(name="registry.search.dscomponent", immediate=true)
public class RegistryMgtUISearchServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUISearchServiceComponent.class);
    private SearchDataHolder dataHolder = SearchDataHolder.getInstance();
    private ServiceRegistration serviceRegistration;

    @Activate
    protected void activate(ComponentContext context) {
        MetadataSearchServiceImpl metadataSearchService = new MetadataSearchServiceImpl();
        this.serviceRegistration = context.getBundleContext().registerService(MetadataSearchService.class.getName(), (Object)metadataSearchService, null);
        try {
            QueryProcessorManager queryProcessorManager = this.dataHolder.getRegistryService().getRegistry("wso2.system.user").getRegistryContext().getQueryProcessorManager();
            if (queryProcessorManager.getQueryProcessor("application/vnd.wso2.xpath.query") == null) {
                queryProcessorManager.setQueryProcessor("application/vnd.wso2.xpath.query", (QueryProcessor)new XPathQueryProcessor(metadataSearchService));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to registry query processors", (Throwable)e);
        }
        log.debug((Object)"******* Registry Search bundle is activated ******* ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        log.debug((Object)"******* Registry Search bundle is deactivated ******* ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    @Reference(name="registry.indexing", service=ContentSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIndexingService")
    protected void setIndexingService(ContentSearchService contentSearchService) {
        this.dataHolder.setContentSearchService(contentSearchService);
    }

    protected void unsetIndexingService(ContentSearchService contentSearchService) {
        this.dataHolder.setContentSearchService(null);
    }

    @Reference(name="registry.attribute.indexing", service=AttributeSearchService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAttributeIndexingService")
    protected void setAttributeIndexingService(AttributeSearchService attributeIndexingService) {
        this.dataHolder.setAttributeIndexingService(attributeIndexingService);
    }

    protected void unsetAttributeIndexingService(AttributeSearchService attributeIndexingService) {
        this.dataHolder.setAttributeIndexingService(null);
    }

    private static class MetadataSearchServiceImpl
    implements MetadataSearchService {
        private MetadataSearchServiceImpl() {
        }

        public ResourceData[] search(UserRegistry registry, Map<String, String> parameters) throws RegistryException {
            LinkedList<String[]> params = new LinkedList<String[]>();
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                params.add(new String[]{e.getKey(), e.getValue()});
            }
            CustomSearchParameterBean parameterBean = new CustomSearchParameterBean();
            parameterBean.setParameterValues((String[][])params.toArray((T[])new String[params.size()][]));
            AdvancedSearchResultsBean resultsBean = AdvancedSearchResultsBeanPopulator.populate(null, registry, parameterBean);
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getResourceDataList();
        }

        public ResourceData[] search(int tenantId, Map<String, String> parameters) throws RegistryException {
            return this.search(SearchDataHolder.getInstance().getRegistryService().getRegistry("wso2.system.user", tenantId), parameters);
        }

        public ResourceData[] search(Map<String, String> parameters) throws RegistryException {
            return this.search(-1234, parameters);
        }
    }
}

