/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.serialize.ContentHandlerWriter;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class OMXMLReader
implements XMLReader {
    private static final String URI_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private final OMElement element;
    private final AttributesAdapter attributesAdapter = new AttributesAdapter();
    private boolean namespaces = true;
    private boolean namespacePrefixes = false;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public OMXMLReader(OMElement element) {
        this.element = element;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.namespaces = value;
        } else if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.namespacePrefixes = value;
        } else {
            throw new SAXNotRecognizedException(name);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.namespacePrefixes;
        }
        if (URI_LEXICAL_HANDLER.equals(name)) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!URI_LEXICAL_HANDLER.equals(name)) {
            throw new SAXNotRecognizedException(name);
        }
        this.lexicalHandler = (LexicalHandler)value;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.parse();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        this.contentHandler.startDocument();
        this.generateParentPrefixMappingEvents(this.element, true);
        this.generateEvents(this.element);
        this.generateParentPrefixMappingEvents(this.element, false);
        this.contentHandler.endDocument();
    }

    private void generatePrefixMappingEvents(OMNamespace ns, boolean start) throws SAXException {
        String prefix = ns.getPrefix();
        if (prefix != null) {
            if (start) {
                this.contentHandler.startPrefixMapping(prefix, ns.getNamespaceURI());
            } else {
                this.contentHandler.endPrefixMapping(prefix);
            }
        }
    }

    private void generatePrefixMappingEvents(OMElement omElement, boolean start) throws SAXException {
        Iterator it = omElement.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            this.generatePrefixMappingEvents((OMNamespace)it.next(), start);
        }
    }

    private void generateParentPrefixMappingEvents(OMElement omElement, boolean start) throws SAXException {
        if (!(omElement.getParent() instanceof OMElement)) {
            return;
        }
        HashSet<String> seenPrefixes = new HashSet<String>();
        Iterator it = omElement.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            seenPrefixes.add(((OMNamespace)it.next()).getPrefix());
        }
        OMElement current = omElement;
        OMContainer parent;
        block1: while ((parent = current.getParent()) instanceof OMElement) {
            current = (OMElement)parent;
            Iterator it2 = current.getAllDeclaredNamespaces();
            while (true) {
                if (!it2.hasNext()) continue block1;
                OMNamespace ns = (OMNamespace)it2.next();
                if (!seenPrefixes.add(ns.getPrefix())) continue;
                this.generatePrefixMappingEvents(ns, start);
            }
            break;
        }
        return;
    }

    private void generateEvents(OMElement omElement) throws SAXException {
        String prefix;
        String uri;
        this.generatePrefixMappingEvents(omElement, true);
        OMNamespace omNamespace = omElement.getNamespace();
        if (omNamespace != null) {
            uri = omNamespace.getNamespaceURI();
            prefix = omNamespace.getPrefix();
        } else {
            uri = "";
            prefix = null;
        }
        String localName = omElement.getLocalName();
        String qName = prefix == null || prefix.isEmpty() ? localName : prefix + ":" + localName;
        this.attributesAdapter.setAttributes(omElement);
        this.contentHandler.startElement(uri, localName, qName, this.attributesAdapter);
        Iterator it = omElement.getChildren();
        while (it.hasNext()) {
            OMNode node = (OMNode)it.next();
            switch (node.getType()) {
                case 1: {
                    this.generateEvents((OMElement)node);
                    break;
                }
                case 4: {
                    this.generateEvents((OMText)node, false);
                    break;
                }
                case 6: {
                    this.generateEvents((OMText)node, true);
                    break;
                }
                case 12: {
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    this.generateEvents((OMText)node, false);
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 5: {
                    if (this.lexicalHandler == null) break;
                    char[] ch = ((OMComment)node).getValue().toCharArray();
                    this.lexicalHandler.comment(ch, 0, ch.length);
                    break;
                }
                case 3: {
                    OMProcessingInstruction pi = (OMProcessingInstruction)node;
                    this.contentHandler.processingInstruction(pi.getTarget(), pi.getValue());
                }
            }
        }
        this.contentHandler.endElement(uri, localName, qName);
        this.generatePrefixMappingEvents(omElement, false);
    }

    private void generateEvents(OMText omText, boolean space) throws SAXException {
        if (omText.isBinary()) {
            DataHandler dh = (DataHandler)omText.getDataHandler();
            Base64EncodingWriterOutputStream out = new Base64EncodingWriterOutputStream(new ContentHandlerWriter(this.contentHandler));
            try {
                dh.writeTo((OutputStream)out);
                out.complete();
            }
            catch (IOException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SAXException) {
                    throw (SAXException)ex.getCause();
                }
                throw new SAXException(ex);
            }
        } else {
            char[] ch = omText.getTextCharacters();
            if (space) {
                this.contentHandler.ignorableWhitespace(ch, 0, ch.length);
            } else {
                this.contentHandler.characters(ch, 0, ch.length);
            }
        }
    }

    protected static class AttributesAdapter
    implements Attributes {
        private List attributes = new ArrayList(5);

        protected AttributesAdapter() {
        }

        public void setAttributes(OMElement element) {
            this.attributes.clear();
            Iterator it = element.getAllAttributes();
            while (it.hasNext()) {
                this.attributes.add(it.next());
            }
        }

        @Override
        public int getLength() {
            return this.attributes.size();
        }

        @Override
        public int getIndex(String qName) {
            int len = this.attributes.size();
            for (int i = 0; i < len; ++i) {
                if (!this.getQName(i).equals(qName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            int len = this.attributes.size();
            for (int i = 0; i < len; ++i) {
                if (!this.getURI(i).equals(uri) || !this.getLocalName(i).equals(localName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getLocalName(int index) {
            return ((OMAttribute)this.attributes.get(index)).getLocalName();
        }

        @Override
        public String getQName(int index) {
            OMAttribute attribute = (OMAttribute)this.attributes.get(index);
            OMNamespace ns = attribute.getNamespace();
            if (ns == null) {
                return attribute.getLocalName();
            }
            String prefix = ns.getPrefix();
            if (prefix == null || prefix.isEmpty()) {
                return attribute.getLocalName();
            }
            return ns.getPrefix() + ":" + attribute.getLocalName();
        }

        @Override
        public String getType(int index) {
            return ((OMAttribute)this.attributes.get(index)).getAttributeType();
        }

        @Override
        public String getType(String qName) {
            int index = this.getIndex(qName);
            return index == -1 ? null : this.getType(index);
        }

        @Override
        public String getType(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            return index == -1 ? null : this.getType(index);
        }

        @Override
        public String getURI(int index) {
            OMNamespace ns = ((OMAttribute)this.attributes.get(index)).getNamespace();
            return ns == null ? "" : ns.getNamespaceURI();
        }

        @Override
        public String getValue(int index) {
            return ((OMAttribute)this.attributes.get(index)).getAttributeValue();
        }

        @Override
        public String getValue(String qName) {
            int index = this.getIndex(qName);
            return index == -1 ? null : this.getValue(index);
        }

        @Override
        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            return index == -1 ? null : this.getValue(index);
        }
    }
}

