/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.linreg;

import Jama.Matrix;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.math3.distribution.TDistribution;
import org.wso2.siddhi.extension.timeseries.linreg.LengthTimeRegressionCalculator;

public class LengthTimeMultipleLinearRegression
extends LengthTimeRegressionCalculator {
    private List<double[]> yValueList = new LinkedList<double[]>();
    private List<double[]> xValueList = new LinkedList<double[]>();
    private Queue<Long> expiryTimeList = new PriorityQueue<Long>();

    public LengthTimeMultipleLinearRegression(int paramCount, long timeWindow, int lengthWindow, int calcInt, double ci) {
        super(paramCount, timeWindow, lengthWindow, calcInt, ci);
    }

    @Override
    protected void addEvent(Object[] data, long expiryTime) {
        this.currentEventTime = expiryTime - this.duration;
        ++this.incCounter;
        ++this.eventCount;
        double[] dataX = new double[this.xParameterCount + 1];
        double[] dataY = new double[1];
        dataX[0] = 1.0;
        dataY[0] = ((Number)data[0]).doubleValue();
        for (int i = 1; i <= this.xParameterCount; ++i) {
            dataX[i] = ((Number)data[i]).doubleValue();
        }
        this.xValueList.add(dataX);
        this.yValueList.add(dataY);
        this.expiryTimeList.add(expiryTime);
    }

    @Override
    protected void removeExpiredEvents() {
        while (this.expiryTimeList.peek() <= this.currentEventTime) {
            this.yValueList.remove(0);
            this.xValueList.remove(0);
            this.expiryTimeList.poll();
            --this.eventCount;
        }
        if (this.eventCount > this.batchSize) {
            this.yValueList.remove(0);
            this.xValueList.remove(0);
            this.expiryTimeList.poll();
            --this.eventCount;
        }
    }

    @Override
    protected Object[] processData() {
        double[][] xArray = (double[][])this.xValueList.toArray((T[])new double[this.eventCount][this.xParameterCount + 1]);
        double[][] yArray = (double[][])this.yValueList.toArray((T[])new double[this.eventCount][1]);
        double[] betaErrors = new double[this.xParameterCount + 1];
        double[] tStats = new double[this.xParameterCount + 1];
        double sse = 0.0;
        double df = this.eventCount - this.xParameterCount - 1;
        double p = 1.0 - this.confidenceInterval;
        Object[] regResults = new Object[this.xParameterCount + 2];
        try {
            Matrix matY = new Matrix(yArray);
            Matrix matX = new Matrix(xArray);
            Matrix matXTranspose = matX.transpose();
            Matrix matXTXInverse = matXTranspose.times(matX).inverse();
            Matrix matBetas = matXTXInverse.times(matXTranspose).times(matY);
            Matrix yHat = matX.times(matBetas);
            for (int i = 0; i < this.eventCount; ++i) {
                sse += (yHat.get(i, 0) - yArray[i][0]) * (yHat.get(i, 0) - yArray[i][0]);
            }
            double mse = sse / df;
            regResults[0] = Math.sqrt(mse);
            TDistribution t = new TDistribution(df);
            for (int j = 0; j <= this.xParameterCount; ++j) {
                betaErrors[j] = Math.sqrt(matXTXInverse.get(j, j) * mse);
                tStats[j] = matBetas.get(j, 0) / betaErrors[j];
                double pValue = 2.0 * (1.0 - t.cumulativeProbability(Math.abs(tStats[j])));
                regResults[j + 1] = pValue > p ? Double.valueOf(0.0) : Double.valueOf(matBetas.get(j, 0));
            }
        }
        catch (RuntimeException e) {
            regResults[0] = 0.0;
            for (int j = 0; j <= this.xParameterCount; ++j) {
                regResults[j + 1] = 0.0;
            }
            return regResults;
        }
        return regResults;
    }
}

