/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.timeseries.extrema;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.extension.timeseries.extrema.util.ExtremaCalculator;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class KalmanMinMaxStreamProcessor
extends StreamProcessor {
    ExtremaType extremaType;
    private int[] variablePosition;
    private int windowSize = 0;
    private LinkedList<StreamEvent> eventStack = null;
    private Queue<Double> valueStack = null;
    private Queue<StreamEvent> uniqueQueue = null;
    private double Q;
    private double R;
    private int minEventPos;
    private int maxEventPos;
    ExtremaCalculator extremaCalculator = null;

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 5) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to KalmanMinMaxStreamProcessor, required 5, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.DOUBLE && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.INT && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.FLOAT && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 1st argument of KalmanMinMaxStreamProcessor, required " + Attribute.Type.DOUBLE + " or " + Attribute.Type.FLOAT + " or " + Attribute.Type.INT + " or " + Attribute.Type.LONG + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        this.variablePosition = ((VariableExpressionExecutor)attributeExpressionExecutors[0]).getPosition();
        try {
            this.Q = Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
        }
        catch (NumberFormatException e) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 2nd argument of KalmanMinMaxStreamProcessor required " + Attribute.Type.DOUBLE + " constant, but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        try {
            this.R = Double.parseDouble(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue()));
        }
        catch (NumberFormatException e) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 3rd argument of KalmanMinMaxStreamProcessor required " + Attribute.Type.DOUBLE + " constant, but found " + attributeExpressionExecutors[2].getReturnType().toString());
        }
        try {
            this.windowSize = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[3]).getValue()));
        }
        catch (NumberFormatException e) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the 4th argument of KalmanMinMaxStreamProcessor required " + Attribute.Type.INT + " constant, but found " + attributeExpressionExecutors[3].getReturnType().toString());
        }
        String extremeType = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[4]).getValue();
        this.extremaType = "min".equalsIgnoreCase(extremeType) ? ExtremaType.MIN : ("max".equalsIgnoreCase(extremeType) ? ExtremaType.MAX : ExtremaType.MINMAX);
        this.eventStack = new LinkedList();
        this.valueStack = new LinkedList<Double>();
        this.uniqueQueue = new LinkedList<StreamEvent>();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("extremaType", Attribute.Type.STRING));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ComplexEventChunk returnEventChunk = new ComplexEventChunk(false);
        KalmanMinMaxStreamProcessor kalmanMinMaxStreamProcessor = this;
        synchronized (kalmanMinMaxStreamProcessor) {
            while (streamEventChunk.hasNext()) {
                StreamEvent event = (StreamEvent)streamEventChunk.next();
                streamEventChunk.remove();
                Double eventKey = (Double)event.getAttribute(this.variablePosition);
                this.extremaCalculator = new ExtremaCalculator(this.Q, this.R);
                this.eventStack.add(event);
                this.valueStack.add(eventKey);
                if (this.eventStack.size() <= this.windowSize) continue;
                Queue<Double> output = this.extremaCalculator.kalmanFilter(this.valueStack);
                switch (this.extremaType) {
                    case MINMAX: {
                        StreamEvent maximumEvent = this.getMaxEvent(output);
                        StreamEvent minimumEvent = this.getMinEvent(output);
                        if (maximumEvent != null && minimumEvent != null) {
                            if (this.maxEventPos > this.minEventPos) {
                                returnEventChunk.add((ComplexEvent)minimumEvent);
                                returnEventChunk.add((ComplexEvent)maximumEvent);
                                break;
                            }
                            returnEventChunk.add((ComplexEvent)maximumEvent);
                            returnEventChunk.add((ComplexEvent)minimumEvent);
                            break;
                        }
                        if (maximumEvent != null) {
                            returnEventChunk.add((ComplexEvent)maximumEvent);
                            break;
                        }
                        if (minimumEvent == null) break;
                        returnEventChunk.add((ComplexEvent)minimumEvent);
                        break;
                    }
                    case MIN: {
                        StreamEvent minimumEvent = this.getMinEvent(output);
                        if (minimumEvent == null) break;
                        returnEventChunk.add((ComplexEvent)minimumEvent);
                        break;
                    }
                    case MAX: {
                        StreamEvent maximumEvent = this.getMaxEvent(output);
                        if (maximumEvent == null) break;
                        returnEventChunk.add((ComplexEvent)maximumEvent);
                    }
                }
                this.eventStack.remove();
                this.valueStack.remove();
            }
        }
        if (returnEventChunk.getFirst() != null) {
            nextProcessor.process(returnEventChunk);
        }
    }

    private StreamEvent getMinEvent(Queue<Double> output) {
        StreamEvent returnMinimumEvent;
        Integer minEventPosition;
        Integer smoothenedMinEventPosition = this.extremaCalculator.findMin(output, 2);
        if (smoothenedMinEventPosition != null && (minEventPosition = this.extremaCalculator.findMin(this.valueStack, 10)) != null && (returnMinimumEvent = this.getExtremaEvent(minEventPosition)) != null) {
            this.minEventPos = minEventPosition;
            this.complexEventPopulater.populateComplexEvent((ComplexEvent)returnMinimumEvent, new Object[]{"min"});
            return returnMinimumEvent;
        }
        return null;
    }

    private StreamEvent getMaxEvent(Queue<Double> output) {
        StreamEvent returnMaximumEvent;
        Integer maxEventPosition;
        Integer smoothenedMaxEventPosition = this.extremaCalculator.findMax(output, 2);
        if (smoothenedMaxEventPosition != null && (maxEventPosition = this.extremaCalculator.findMax(this.valueStack, 10)) != null && (returnMaximumEvent = this.getExtremaEvent(maxEventPosition)) != null) {
            this.maxEventPos = maxEventPosition;
            this.complexEventPopulater.populateComplexEvent((ComplexEvent)returnMaximumEvent, new Object[]{"max"});
            return returnMaximumEvent;
        }
        return null;
    }

    private StreamEvent getExtremaEvent(Integer eventPosition) {
        StreamEvent extremaEvent = this.eventStack.get(eventPosition);
        if (!this.uniqueQueue.contains(extremaEvent)) {
            if (this.uniqueQueue.size() > 5) {
                this.uniqueQueue.remove();
            }
            this.uniqueQueue.add(extremaEvent);
            return this.streamEventCloner.copyStreamEvent(extremaEvent);
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, LinkedList<StreamEvent>>("EventStack", this.eventStack), new AbstractMap.SimpleEntry<String, Queue<Double>>("ValueStack", this.valueStack), new AbstractMap.SimpleEntry<String, Queue<StreamEvent>>("UniqueQueue", this.uniqueQueue)};
    }

    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.eventStack = (LinkedList)stateEntry.getValue();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.valueStack = (Queue)stateEntry2.getValue();
        Map.Entry stateEntry3 = (Map.Entry)state[2];
        this.uniqueQueue = (Queue)stateEntry3.getValue();
    }

    public static enum ExtremaType {
        MIN,
        MAX,
        MINMAX;

    }
}

