/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.sharedmemory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.event.core.delivery.MatchingManager;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.sharedmemory.SharedMemorySubscriptionStorage;
import org.wso2.carbon.registry.event.core.sharedmemory.util.SharedMemoryCacheConstants;
import org.wso2.carbon.registry.event.core.subscription.Subscription;

public class SharedMemoryMatchingManager
implements MatchingManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SharedMemoryMatchingManager.class);
    private static boolean cacheInit = false;

    private static Cache<Integer, SharedMemorySubscriptionStorage> getTenantIDInMemorySubscriptionStorageCache() {
        if (cacheInit) {
            return Caching.getCacheManagerFactory().getCacheManager("inMemoryEventCacheManager").getCache("tenantIDInMemorySubscriptionStorageCache");
        }
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager("inMemoryEventCacheManager");
        cacheInit = true;
        log.info((Object)"Tenant ID InMemory Subscription Storage Cache Initialized");
        return cacheManager.createCacheBuilder("tenantIDInMemorySubscriptionStorageCache").setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)SharedMemoryCacheConstants.CACHE_INVALIDATION_TIME.intValue())).setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)SharedMemoryCacheConstants.CACHE_INVALIDATION_TIME.intValue())).setStoreByValue(false).build();
    }

    @Override
    public void addSubscription(Subscription subscription) {
        SharedMemorySubscriptionStorage inMemorySubscriptionStorage = (SharedMemorySubscriptionStorage)SharedMemoryMatchingManager.getTenantIDInMemorySubscriptionStorageCache().get((Object)CarbonContext.getThreadLocalCarbonContext().getTenantId());
        inMemorySubscriptionStorage.addSubscription(subscription);
    }

    @Override
    public List<Subscription> getMatchingSubscriptions(String topicName) {
        SharedMemorySubscriptionStorage inMemorySubscriptionStorage = (SharedMemorySubscriptionStorage)SharedMemoryMatchingManager.getTenantIDInMemorySubscriptionStorageCache().get((Object)CarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (inMemorySubscriptionStorage != null) {
            return inMemorySubscriptionStorage.getMatchingSubscriptions(topicName);
        }
        return new ArrayList<Subscription>();
    }

    @Override
    public void unSubscribe(String subscriptionID) throws EventBrokerException {
        SharedMemorySubscriptionStorage inMemorySubscriptionStorage = (SharedMemorySubscriptionStorage)SharedMemoryMatchingManager.getTenantIDInMemorySubscriptionStorageCache().get((Object)CarbonContext.getThreadLocalCarbonContext().getTenantId());
        inMemorySubscriptionStorage.unSubscribe(subscriptionID);
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        SharedMemorySubscriptionStorage inMemorySubscriptionStorage = (SharedMemorySubscriptionStorage)SharedMemoryMatchingManager.getTenantIDInMemorySubscriptionStorageCache().get((Object)CarbonContext.getThreadLocalCarbonContext().getTenantId());
        inMemorySubscriptionStorage.renewSubscription(subscription);
    }

    @Override
    public void initializeTenant() throws EventBrokerException {
        if (SharedMemoryMatchingManager.getTenantIDInMemorySubscriptionStorageCache().get((Object)CarbonContext.getThreadLocalCarbonContext().getTenantId()) == null) {
            SharedMemoryMatchingManager.getTenantIDInMemorySubscriptionStorageCache().put((Object)CarbonContext.getThreadLocalCarbonContext().getTenantId(), (Object)new SharedMemorySubscriptionStorage());
        }
    }
}

