/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.topic.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.registry.event.core.internal.util.JavaUtil;
import org.wso2.carbon.registry.event.core.subscription.Subscription;
import org.wso2.carbon.registry.event.core.topic.TopicManager;
import org.wso2.carbon.registry.event.core.topic.TopicNode;
import org.wso2.carbon.registry.event.core.topic.TopicRolePermission;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class RegistryTopicManager
implements TopicManager {
    private static Log log = LogFactory.getLog(RegistryTopicManager.class);
    private static final String AT_REPLACE_CHAR = "_";
    private static final String TOPIC_ROLE_PREFIX = "T_";
    private String topicStoragePath;
    private RegistryService registryService;

    public RegistryTopicManager(String topicStoragePath) {
        this.topicStoragePath = topicStoragePath;
        this.registryService = EventBrokerHolder.getInstance().getRegistryService();
    }

    @Override
    public TopicNode getTopicTree() throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            if (!userRegistry.resourceExists(this.topicStoragePath)) {
                userRegistry.put(this.topicStoragePath, (Resource)userRegistry.newCollection());
            }
            Resource root = userRegistry.get(this.topicStoragePath);
            TopicNode rootTopic = new TopicNode("/", "/");
            this.buildTopicTree(rootTopic, (Collection)root, userRegistry);
            return rootTopic;
        }
        catch (RegistryException e) {
            throw new EventBrokerException(e.getMessage(), e);
        }
    }

    private void buildTopicTree(TopicNode topicNode, Collection resource, UserRegistry userRegistry) throws EventBrokerException {
        try {
            String[] children = resource.getChildren();
            if (children != null) {
                ArrayList<TopicNode> nodes = new ArrayList<TopicNode>();
                for (String childTopic : children) {
                    String nodeName;
                    Resource childResource = userRegistry.get(childTopic);
                    if (!(childResource instanceof Collection)) continue;
                    if (childTopic.endsWith("/")) {
                        childTopic = childTopic.substring(0, childTopic.length() - 2);
                    }
                    if ((nodeName = childTopic.substring(childTopic.lastIndexOf("/") + 1)).equals("ws.subscriptions") || nodeName.equals("jms.subscriptions")) continue;
                    childTopic = childTopic.substring(childTopic.indexOf(this.topicStoragePath) + this.topicStoragePath.length() + 1);
                    TopicNode childNode = new TopicNode(nodeName, childTopic);
                    nodes.add(childNode);
                    this.buildTopicTree(childNode, (Collection)childResource, userRegistry);
                }
                topicNode.setChildren(nodes.toArray(new TopicNode[nodes.size()]));
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException(e.getMessage(), e);
        }
    }

    @Override
    public void addTopic(String topicName) throws EventBrokerException {
        if (!this.validateTopicName(topicName)) {
            throw new EventBrokerException("Topic name " + topicName + " is not a valid topic name. Only alphanumeric characters, hyphens (-), stars(*), hash(#) ,dot(.),question mark(?) and underscores (_) are allowed.");
        }
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (!userRegistry.resourceExists(resourcePath)) {
                Collection collection = userRegistry.newCollection();
                userRegistry.put(resourcePath, (Resource)collection);
                UserRealm userRealm = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId());
                userRealm.getAuthorizationManager().authorizeUser(loggedInUser, resourcePath, "changePermission");
                userRealm.getAuthorizationManager().authorizeUser(loggedInUser, resourcePath, "publish");
                userRealm.getAuthorizationManager().authorizeUser(loggedInUser, resourcePath, "subscribe");
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the config registry", e);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Error while granting user " + loggedInUser + ", permission " + "changePermission" + ", on topic " + topicName, e);
        }
    }

    private String removeResourcePath(String topic) {
        String resourcePath = this.topicStoragePath;
        if (topic.contains(resourcePath)) {
            topic = topic.substring(topic.indexOf(resourcePath) + resourcePath.length());
        }
        return topic;
    }

    @Override
    public TopicRolePermission[] getTopicRolePermission(String topicName) throws EventBrokerException {
        String topicResourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        ArrayList<TopicRolePermission> topicRolePermissions = new ArrayList<TopicRolePermission>();
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
        try {
            for (String role : userRealm.getUserStoreManager().getRoleNames()) {
                if (role.equals(adminRole) || "system/wso2.anonymous.role".equals(role)) continue;
                TopicRolePermission topicRolePermission = new TopicRolePermission();
                topicRolePermission.setRoleName(role);
                topicRolePermission.setAllowedToSubscribe(userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe"));
                topicRolePermission.setAllowedToPublish(userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish"));
                topicRolePermissions.add(topicRolePermission);
            }
            return topicRolePermissions.toArray(new TopicRolePermission[topicRolePermissions.size()]);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Cannot access the UserStore manager ", e);
        }
    }

    @Override
    public void updatePermissions(String topicName, TopicRolePermission[] topicRolePermissions) throws EventBrokerException {
        String topicResourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(loggedInUser, topicResourcePath, "changePermission") && !JavaUtil.isAdmin(loggedInUser)) {
                throw new EventBrokerException(" User " + loggedInUser + " cannot change the permissions of " + topicName);
            }
            for (TopicRolePermission topicRolePermission : topicRolePermissions) {
                String role = topicRolePermission.getRoleName();
                if (topicRolePermission.isAllowedToSubscribe()) {
                    if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe")) {
                        userRealm.getAuthorizationManager().authorizeRole(role, topicResourcePath, "subscribe");
                    }
                } else if (userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "subscribe")) {
                    userRealm.getAuthorizationManager().denyRole(role, topicResourcePath, "subscribe");
                }
                if (topicRolePermission.isAllowedToPublish()) {
                    if (userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish")) continue;
                    userRealm.getAuthorizationManager().authorizeRole(role, topicResourcePath, "publish");
                    continue;
                }
                if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, topicResourcePath, "publish")) continue;
                userRealm.getAuthorizationManager().denyRole(role, topicResourcePath, "publish");
            }
            RegistryTopicManager.authorizePermissionsToLoggedInUser(loggedInUser, topicName, topicResourcePath, userRealm);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Cannot access the user store manager", e);
        }
    }

    public String getTopicStoragePath() {
        return this.topicStoragePath;
    }

    public void setTopicStoragePath(String topicStoragePath) {
        this.topicStoragePath = topicStoragePath;
    }

    @Override
    public Subscription[] getSubscriptions(String topicName, boolean withChildren) throws EventBrokerException {
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        LinkedList<String> pathsQueue = new LinkedList<String>();
        String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
        pathsQueue.add(resourcePath);
        while (!pathsQueue.isEmpty()) {
            this.addSubscriptions((String)pathsQueue.remove(), subscriptions, pathsQueue, withChildren);
        }
        return subscriptions.toArray(new Subscription[subscriptions.size()]);
    }

    @Override
    public Subscription[] getJMSSubscriptions(String topicName) throws EventBrokerException {
        try {
            Subscription[] subscriptionsArray = new Subscription[]{};
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            if (!resourcePath.endsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            if (userRegistry.resourceExists(resourcePath = resourcePath + "jms.subscriptions")) {
                Collection subscriptionCollection = (Collection)userRegistry.get(resourcePath);
                subscriptionsArray = new Subscription[subscriptionCollection.getChildCount()];
                int index = 0;
                for (String subs : subscriptionCollection.getChildren()) {
                    Collection subscription = (Collection)userRegistry.get(subs);
                    Subscription subscriptionDetails = new Subscription();
                    subscriptionDetails.setId(subscription.getProperty("Name"));
                    subscriptionDetails.setOwner(subscription.getProperty("Owner"));
                    subscriptionDetails.setCreatedTime(ConverterUtil.convertToDate((String)subscription.getProperty("createdTime")));
                    subscriptionsArray[index++] = subscriptionDetails;
                }
            }
            return subscriptionsArray;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot read the registry resources ", e);
        }
    }

    private void addSubscriptions(String resourcePath, List<Subscription> subscriptions, Queue<String> pathsQueue, boolean withChildren) throws EventBrokerException {
        try {
            Resource resource;
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String subscriptionsPath = this.getSubscriptionsPath(resourcePath);
            if (userRegistry.resourceExists(subscriptionsPath)) {
                Collection collection = (Collection)userRegistry.get(subscriptionsPath);
                for (String subscriptionPath : collection.getChildren()) {
                    Resource subscriptionResource = userRegistry.get(subscriptionPath);
                    Subscription subscription = JavaUtil.getSubscription(subscriptionResource);
                    subscription.setTopicName(this.removeResourcePath(resourcePath));
                    if (subscriptionPath.endsWith("/")) {
                        subscriptionPath = subscriptionsPath.substring(0, subscriptionPath.lastIndexOf("/"));
                    }
                    subscription.setId(subscriptionPath.substring(subscriptionPath.lastIndexOf("/") + 1));
                    subscriptions.add(subscription);
                }
            }
            if (withChildren && (resource = userRegistry.get(resourcePath)) instanceof Collection) {
                Collection childResources = (Collection)resource;
                for (String childResourcePath : childResources.getChildren()) {
                    if ("ws.subscriptions".contains(childResourcePath) || "jms.subscriptions".contains(childResourcePath)) continue;
                    pathsQueue.add(childResourcePath);
                }
            }
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the registry", e);
        }
    }

    private String getSubscriptionsPath(String topicName) {
        if (!topicName.endsWith("/")) {
            topicName = topicName + "/";
        }
        topicName = topicName + "ws.subscriptions";
        return topicName;
    }

    private boolean validateTopicName(String topicName) {
        return Pattern.matches("[[a-zA-Z]+[^(\\x00-\\x80)]+[0-9_\\-/#*:.?&\\s()]+]+", topicName);
    }

    @Override
    public String[] getBackendRoles() throws EventBrokerException {
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String[] cleanedRoles = new String[]{};
        try {
            String adminRole = EventBrokerHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
            String[] allRoles = userRealm.getUserStoreManager().getRoleNames();
            if (allRoles != null && allRoles.length > 1) {
                ArrayList allRolesArrayList = new ArrayList();
                Collections.addAll(allRolesArrayList, allRoles);
                Iterator it = allRolesArrayList.iterator();
                while (it.hasNext()) {
                    String nextRole = (String)it.next();
                    if (!nextRole.equals(adminRole) && !nextRole.equals("system/wso2.anonymous.role")) continue;
                    it.remove();
                }
                cleanedRoles = allRolesArrayList.toArray(new String[allRolesArrayList.size()]);
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Unable to get Roles from user store", e);
        }
        return cleanedRoles;
    }

    @Override
    public boolean removeTopic(String topicName) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            RegistryTopicManager.removeRoleCreateForLoggedInUser(topicName);
            if (userRegistry.resourceExists(resourcePath)) {
                userRegistry.delete(resourcePath);
                return true;
            }
            return false;
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the config registry", e);
        }
    }

    @Override
    public boolean isTopicExists(String topicName) throws EventBrokerException {
        try {
            UserRegistry userRegistry = this.registryService.getGovernanceSystemRegistry(EventBrokerHolder.getInstance().getTenantId());
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            return userRegistry.resourceExists(resourcePath);
        }
        catch (RegistryException e) {
            throw new EventBrokerException("Cannot access the config registry");
        }
    }

    private static void authorizePermissionsToLoggedInUser(String username, String destinationName, String destinationId, UserRealm userRealm) throws UserStoreException {
        String newDestinationName = destinationName.replace("@", AT_REPLACE_CHAR);
        String roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + newDestinationName.replace("/", "-")));
        UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
        if (!userStoreManager.isExistingRole(roleName)) {
            String[] user = new String[]{MultitenantUtils.getTenantAwareUsername((String)username)};
            userStoreManager.addRole(roleName, user, null);
            userRealm.getAuthorizationManager().authorizeRole(roleName, destinationId, "subscribe");
            userRealm.getAuthorizationManager().authorizeRole(roleName, destinationId, "publish");
            userRealm.getAuthorizationManager().authorizeRole(roleName, destinationId, "changePermission");
        } else {
            log.warn((Object)("Unable to provide permissions to the user,  " + username + ", to subscribe and publish to " + newDestinationName));
        }
    }

    private static void removeRoleCreateForLoggedInUser(String destinationName) throws EventBrokerException {
        String newDestinationName = destinationName.replace("@", AT_REPLACE_CHAR);
        String roleName = UserCoreUtil.addInternalDomainName((String)(TOPIC_ROLE_PREFIX + newDestinationName.replace("/", "-")));
        try {
            UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            if (userStoreManager.isExistingRole(roleName)) {
                userStoreManager.deleteRole(roleName);
            }
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Error while deleting " + newDestinationName, e);
        }
    }
}

