/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.subscription.registry;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.wso2.carbon.registry.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.internal.subscription.registry.RegistrySubscriptionManager;
import org.wso2.carbon.registry.event.core.internal.util.JavaUtil;
import org.wso2.carbon.registry.event.core.subscription.Subscription;
import org.wso2.carbon.registry.event.core.subscription.SubscriptionManager;
import org.wso2.carbon.registry.event.core.subscription.SubscriptionManagerFactory;

public class RegistrySubscriptionManagerFactory
implements SubscriptionManagerFactory {
    public static final String EB_ELE_TOPIC_STORAGE_PATH = "topicStoragePath";
    public static final String EB_ELE_INDEX_STORAGE_PATH = "indexStoragePath";
    public static final String EB_ELE_SUBSCRIPTION = "subscription";
    public static final String EB_ATTR_ID = "id";
    public static final String EB_ELE_TOPIC = "topic";
    public static final String EB_ELE_EVENT_SINK_URL = "eventSinkURL";
    public static final String EB_ELE_EXPIRES = "expires";
    public static final String EB_ELE_OWNER = "owner";

    @Override
    public SubscriptionManager getSubscriptionManager(OMElement config) throws EventBrokerConfigurationException {
        String topicStoragePath = JavaUtil.getValue(config, EB_ELE_TOPIC_STORAGE_PATH);
        String indexStoragePath = JavaUtil.getValue(config, EB_ELE_INDEX_STORAGE_PATH);
        RegistrySubscriptionManager registrySubscriptionManager = new RegistrySubscriptionManager(topicStoragePath, indexStoragePath);
        Iterator subscriptionsIter = config.getChildrenWithName(new QName("http://wso2.org/carbon/event/broker", EB_ELE_SUBSCRIPTION));
        OMElement subscriptionElement = null;
        Subscription subscription = null;
        Object id = null;
        while (subscriptionsIter.hasNext()) {
            subscriptionElement = (OMElement)subscriptionsIter.next();
            subscription = new Subscription();
            subscription.setId(subscriptionElement.getAttributeValue(new QName(null, EB_ATTR_ID)));
            try {
                if (registrySubscriptionManager.getSubscription(subscription.getId()) != null) continue;
                subscription.setTopicName(JavaUtil.getValue(subscriptionElement, EB_ELE_TOPIC));
                subscription.setOwner(JavaUtil.getValue(subscriptionElement, EB_ELE_OWNER));
                subscription.setEventSinkURL(JavaUtil.getValue(subscriptionElement, EB_ELE_EVENT_SINK_URL));
                subscription.setExpires(ConverterUtil.convertToDateTime((String)JavaUtil.getValue(subscriptionElement, EB_ELE_EXPIRES)));
                if (subscription.getEventSinkURL().startsWith("sqs://")) {
                    subscription.setEventDispatcherName("EventSinkDispatcher");
                } else {
                    subscription.setEventDispatcherName("wsEventDispatcher");
                }
                registrySubscriptionManager.addSubscription(subscription);
            }
            catch (EventBrokerException e) {
                throw new EventBrokerConfigurationException("Can not access the registry to read subscrptions ", e);
            }
        }
        return registrySubscriptionManager;
    }
}

