/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.notify;

import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.registry.event.core.Message;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.notify.NotificationManager;
import org.wso2.carbon.registry.event.core.subscription.EventDispatcher;
import org.wso2.carbon.registry.event.core.subscription.Subscription;

public class CarbonNotificationManager
implements NotificationManager {
    private Map<String, EventDispatcher> eventDispatchMap = new ConcurrentHashMap<String, EventDispatcher>();

    @Override
    public void sendNotification(Message message, Subscription subscription) throws EventBrokerException {
        Calendar calendar;
        if (subscription.getExpires() != null && (calendar = Calendar.getInstance()).after(subscription.getExpires())) {
            return;
        }
        if (subscription.getEventDispatcher() != null) {
            subscription.getEventDispatcher().notify(message, subscription);
        } else if (subscription.getEventDispatcherName() != null) {
            EventDispatcher eventDispatcher = this.eventDispatchMap.get(subscription.getEventDispatcherName());
            if (eventDispatcher == null) {
                throw new EventBrokerException("Event dispatcher with name " + subscription.getEventDispatcherName() + " is not exists");
            }
            eventDispatcher.notify(message, subscription);
        } else {
            throw new EventBrokerException("Can not send the notification ");
        }
    }

    public void registerEventDispatcher(String name, EventDispatcher eventDispatcher) {
        this.eventDispatchMap.put(name, eventDispatcher);
    }
}

