/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.delivery.jms;

import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.internal.delivery.jms.JMSMessageListener;
import org.wso2.carbon.registry.event.core.subscription.Subscription;

public class JMSSubscriptionDetails {
    private TopicSubscriber topicSubscriber;
    private TopicSession topicSession;
    private TopicConnection topicConnection;

    public JMSSubscriptionDetails(TopicSubscriber topicSubscriber, TopicSession topicSession, TopicConnection topicConnection) {
        this.topicSubscriber = topicSubscriber;
        this.topicSession = topicSession;
        this.topicConnection = topicConnection;
    }

    public void close() throws EventBrokerException {
        try {
            this.topicSubscriber.close();
            this.topicSession.close();
            this.topicConnection.stop();
            this.topicConnection.close();
        }
        catch (JMSException e) {
            throw new EventBrokerException("Can not close connections ", e);
        }
    }

    public void renewSubscription(Subscription subscription) throws JMSException {
        JMSMessageListener jmsMessageListener = (JMSMessageListener)this.topicSubscriber.getMessageListener();
        jmsMessageListener.renewSubscription(subscription);
    }
}

