/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.delivery.jms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.event.core.Message;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.notify.NotificationManager;
import org.wso2.carbon.registry.event.core.subscription.Subscription;

public class JMSMessageListener
implements MessageListener {
    private Log log = LogFactory.getLog(JMSMessageListener.class);
    private NotificationManager notificationManager;
    private Subscription subscription;

    public JMSMessageListener(NotificationManager notificationManager, Subscription subscription) {
        this.notificationManager = notificationManager;
        this.subscription = subscription;
    }

    public void renewSubscription(Subscription subscription) {
        this.subscription.setExpires(subscription.getExpires());
        this.subscription.setProperties(subscription.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message message) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.subscription.getTenantId());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(this.subscription.getOwner());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                StAXOMBuilder stAXOMBuilder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(textMessage.getText().getBytes()));
                Message messageToSend = new Message();
                messageToSend.setMessage(stAXOMBuilder.getDocumentElement());
                Enumeration propertyNames = message.getPropertyNames();
                String key = null;
                while (propertyNames.hasMoreElements()) {
                    key = (String)propertyNames.nextElement();
                    messageToSend.addProperty(key, message.getStringProperty(key));
                }
                this.notificationManager.sendNotification(messageToSend, this.subscription);
            } else {
                this.log.warn((Object)"Non text message received");
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"Can not read the text message ", (Throwable)e);
        }
        catch (XMLStreamException e) {
            this.log.error((Object)"Can not build the xml string", (Throwable)e);
        }
        catch (EventBrokerException e) {
            this.log.error((Object)"Can not send the notification ", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

