/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.delivery.inmemory;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.event.core.delivery.DeliveryManager;
import org.wso2.carbon.registry.event.core.delivery.DeliveryManagerFactory;
import org.wso2.carbon.registry.event.core.delivery.MatchingManagerFactory;
import org.wso2.carbon.registry.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.registry.event.core.internal.delivery.inmemory.InMemoryDeliveryManager;
import org.wso2.carbon.registry.event.core.internal.util.JavaUtil;

public class InMemoryDeliveryManagerFactory
implements DeliveryManagerFactory {
    public static final String EB_DM_MIN_SPARE_THREADS = "minSpareThreads";
    public static final String EB_DM_MAX_THREADS = "maxThreads";
    public static final String EB_DM_MAX_QUEUED_REQUESTS = "maxQueuedRequests";
    public static final String EB_DM_KEEP_ALIVE_TIME = "keepAliveTime";
    public static final String EB_DM_TOPIC_STORAGE_PATH = "topicStoragePath";

    @Override
    public DeliveryManager getDeliveryManger(OMElement config) throws EventBrokerConfigurationException {
        int minSpareThreads = Integer.parseInt(JavaUtil.getValue(config, EB_DM_MIN_SPARE_THREADS));
        int maxThreads = Integer.parseInt(JavaUtil.getValue(config, EB_DM_MAX_THREADS));
        int maxQueuedRequests = Integer.parseInt(JavaUtil.getValue(config, EB_DM_MAX_QUEUED_REQUESTS));
        int keepAliveTime = Integer.parseInt(JavaUtil.getValue(config, EB_DM_KEEP_ALIVE_TIME));
        String topicStoragePath = JavaUtil.getValue(config, EB_DM_TOPIC_STORAGE_PATH);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(maxQueuedRequests);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(minSpareThreads, maxThreads, keepAliveTime, TimeUnit.NANOSECONDS, queue);
        InMemoryDeliveryManager delivaryManager = new InMemoryDeliveryManager(executor, topicStoragePath);
        OMElement matchingManagerElement = config.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", "matchingManager"));
        MatchingManagerFactory factory = (MatchingManagerFactory)JavaUtil.getObject(matchingManagerElement);
        delivaryManager.setMatchingManager(factory.getMatchingManager(matchingManagerElement));
        return delivaryManager;
    }
}

