/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.delivery;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.event.core.Message;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.notify.NotificationManager;
import org.wso2.carbon.registry.event.core.subscription.Subscription;

public class Worker
implements Runnable {
    private NotificationManager notificationManager;
    private Message message;
    private Subscription subscription;
    private static final Log log = LogFactory.getLog(Worker.class);

    public Worker(NotificationManager notificationManager, Message message, Subscription subscription) {
        this.notificationManager = notificationManager;
        this.message = message;
        this.subscription = subscription;
    }

    @Override
    public void run() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.subscription.getTenantId());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(this.subscription.getOwner());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            this.notificationManager.sendNotification(this.message, this.subscription);
        }
        catch (EventBrokerException e) {
            log.error((Object)"Can not send the notification ", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

