/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal.builder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.registry.event.core.EventBroker;
import org.wso2.carbon.registry.event.core.EventBrokerFactory;
import org.wso2.carbon.registry.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.utils.CarbonUtils;

public class EventBrokerBuilder {
    public static EventBroker createEventBroker() throws EventBrokerConfigurationException {
        OMElement ebConfig = EventBrokerBuilder.loadConfigXML();
        if (!ebConfig.getQName().equals(new QName("http://wso2.org/carbon/event/broker", "eventBrokerConfig"))) {
            throw new EventBrokerConfigurationException("Invalid root element in event broker config");
        }
        OMElement eventBroker = ebConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/event/broker", "eventBroker"));
        String className = eventBroker.getAttributeValue(new QName(null, "class"));
        try {
            Class<?> brokerImplClass = Class.forName(className);
            EventBrokerFactory eventBrokerFactory = (EventBrokerFactory)brokerImplClass.newInstance();
            return eventBrokerFactory.getEventBroker(eventBroker);
        }
        catch (ClassNotFoundException e) {
            throw new EventBrokerConfigurationException("Can not load the class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new EventBrokerConfigurationException("Can not access the class " + className, e);
        }
        catch (InstantiationException e) {
            throw new EventBrokerConfigurationException("Can not instantiate the class " + className, e);
        }
    }

    private static OMElement loadConfigXML() throws EventBrokerConfigurationException {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "registry-event-broker.xml";
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new EventBrokerConfigurationException("registry-event-broker.xmlcannot be found in the path : " + path, e);
        }
        catch (XMLStreamException e) {
            throw new EventBrokerConfigurationException("Invalid XML for registry-event-broker.xml located in the path : " + path, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ingored) {
                throw new EventBrokerConfigurationException("Can not close the input stream");
            }
        }
    }
}

