/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.event.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.event.core.Message;
import org.wso2.carbon.registry.event.core.delivery.DeliveryManager;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;

public class EventPublisher
implements Runnable {
    private static final Log log = LogFactory.getLog(EventPublisher.class);
    private Message message;
    private String topicName;
    private DeliveryManager delivaryManager;
    private int deliveryMode;
    private int tenantID;

    public EventPublisher(Message message, String topicName, DeliveryManager delivaryManager, int deliveryMode, int tenantID) {
        this.message = message;
        this.topicName = topicName;
        this.delivaryManager = delivaryManager;
        this.deliveryMode = deliveryMode;
        this.tenantID = tenantID;
    }

    @Override
    public void run() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantID);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            this.delivaryManager.publish(this.message, this.topicName, this.deliveryMode);
        }
        catch (EventBrokerException e) {
            log.error((Object)"Can not publish the message ", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

