/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQMessageReceiver;
import org.apache.axis2.transport.rabbitmq.RabbitMQRecoveryListener;
import org.apache.axis2.transport.rabbitmq.RabbitMQUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceTaskManager {
    private static final Log log = LogFactory.getLog(ServiceTaskManager.class);
    private volatile Hashtable<String, String> rabbitMQProperties = new Hashtable();
    private final List<MessageListenerTask> pollingTasks = Collections.synchronizedList(new ArrayList());
    private final RabbitMQConnectionPool rabbitMQConnectionPool;
    private volatile RabbitMQMessageReceiver rabbitMQMessageReceiver;
    private volatile String serviceName;
    private WorkerPool workerPool = null;
    private Connection connection;
    private String factoryName;

    public ServiceTaskManager(RabbitMQConnectionPool rabbitMQConnectionPool, String factoryName) {
        this.rabbitMQConnectionPool = rabbitMQConnectionPool;
        this.factoryName = factoryName;
    }

    public void start() throws Exception {
        int concurrentConsumers = NumberUtils.toInt((String)this.rabbitMQProperties.get("rabbitmq.concurrent.consumer.count"), (int)1);
        this.connection = this.rabbitMQConnectionPool.borrowObject(this.factoryName);
        for (int i = 0; i < concurrentConsumers; ++i) {
            this.workerPool.execute((Runnable)new MessageListenerTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask listenerTask : this.pollingTasks) {
                listenerTask.close();
            }
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setRabbitMQMessageReceiver(RabbitMQMessageReceiver rabbitMQMessageReceiver) {
        this.rabbitMQMessageReceiver = rabbitMQMessageReceiver;
    }

    public void addRabbitMQProperties(Map<String, String> rabbitMQProperties) {
        this.rabbitMQProperties.putAll(rabbitMQProperties);
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    private class MessageListenerTask
    implements Runnable,
    Consumer {
        private Channel channel;
        private String queueName;
        private boolean autoAck;
        private long maxDeadLetteredCount;

        private MessageListenerTask() throws IOException {
            this.channel = ServiceTaskManager.this.connection.createChannel();
            ((Recoverable)this.channel).addRecoveryListener((RecoveryListener)new RabbitMQRecoveryListener());
            ServiceTaskManager.this.pollingTasks.add(this);
        }

        private void initConsumer() throws IOException {
            int qos = NumberUtils.toInt((String)((String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.channel.consumer.qos")), (int)0);
            this.channel.basicQos(qos);
            this.queueName = (String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.queue.name");
            RabbitMQUtils.declareQueue(this.channel, this.queueName, ServiceTaskManager.this.rabbitMQProperties);
            String exchangeName = (String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.exchange.name");
            RabbitMQUtils.declareExchange(this.channel, exchangeName, ServiceTaskManager.this.rabbitMQProperties);
            this.maxDeadLetteredCount = NumberUtils.toLong((String)((String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.message.max.dead.lettered.count")));
            String consumerTag = (String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.consumer.tag");
            this.autoAck = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)((String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.queue.auto.ack"))), (boolean)true);
            if (StringUtils.isNotEmpty((String)consumerTag)) {
                this.channel.basicConsume(this.queueName, this.autoAck, consumerTag, (Consumer)this);
            } else {
                this.channel.basicConsume(this.queueName, this.autoAck, (Consumer)this);
            }
        }

        public void handleConsumeOk(String consumerTag) {
            log.info((Object)("Start consuming queue: " + this.queueName + " with consumer tag: " + consumerTag + " for service: " + ServiceTaskManager.this.serviceName));
        }

        public void handleCancelOk(String consumerTag) {
            log.info((Object)("The consumer with consumer tag: " + consumerTag + " stops listening to new messages."));
        }

        public void handleCancel(String consumerTag) throws IOException {
            log.info((Object)("The consumer with consumer tag: " + consumerTag + " unexpectedly stops listening to new messages."));
        }

        public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
            if (signal.isInitiatedByApplication()) {
                log.info((Object)("The connection to the messaging server was shut down. Consumer tag " + consumerTag));
            } else if (signal.getReference() instanceof Channel) {
                int channelNumber = ((Channel)signal.getReference()).getChannelNumber();
                log.info((Object)("The consumer on channel number: " + channelNumber + " with consumer tag: " + consumerTag + " was shut down."));
            } else {
                log.info((Object)("The consumer with consumer tag: " + consumerTag + " was shut down."));
            }
        }

        public void handleRecoverOk(String consumerTag) {
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            boolean successful = ServiceTaskManager.this.rabbitMQMessageReceiver.onMessage(properties, body);
            if (successful) {
                if (!this.autoAck) {
                    this.channel.basicAck(envelope.getDeliveryTag(), false);
                }
            } else {
                ArrayList xDeathHeader = (ArrayList)properties.getHeaders().get("x-death");
                if (xDeathHeader != null && xDeathHeader.size() > 0 && this.maxDeadLetteredCount != -1L) {
                    Long count = (Long)((HashMap)xDeathHeader.get(0)).get("count");
                    if (count <= this.maxDeadLetteredCount) {
                        this.channel.basicReject(envelope.getDeliveryTag(), false);
                        log.info((Object)("The rejected message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " on the queue: " + this.queueName + " is dead-lettered " + count + " time(s)."));
                    } else {
                        this.proceedAfterMaxDeadLetteredCount(envelope, properties, body);
                    }
                } else {
                    this.channel.basicReject(envelope.getDeliveryTag(), false);
                    log.info((Object)("The rejected message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " on the queue: " + this.queueName + " will discard or dead-lettered."));
                }
            }
        }

        private void proceedAfterMaxDeadLetteredCount(Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            String routingKey = (String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.message.error.queue.routing.key");
            String exchangeName = (String)ServiceTaskManager.this.rabbitMQProperties.get("rabbitmq.message.error.exchange.name");
            if (StringUtils.isNotEmpty((String)routingKey) && StringUtils.isNotEmpty((String)exchangeName)) {
                this.channel.basicPublish(exchangeName, routingKey, properties, body);
                this.channel.basicAck(envelope.getDeliveryTag(), false);
                log.info((Object)("The max dead lettered count exceeded. Hence message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " publish to the exchange: " + exchangeName + " with the routing key: " + routingKey + "."));
            } else if (StringUtils.isNotEmpty((String)routingKey) && StringUtils.isEmpty((String)exchangeName)) {
                this.channel.basicPublish("", routingKey, properties, body);
                this.channel.basicAck(envelope.getDeliveryTag(), false);
                log.info((Object)("The max dead lettered count exceeded. Hence message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " publish to the default exchange with the routing key: " + routingKey + "."));
            } else {
                this.channel.basicAck(envelope.getDeliveryTag(), false);
                log.info((Object)("The max dead lettered count exceeded. No 'rabbitmq.message.error.queue.routing.key' specified for publishing the message. Hence the message with message id: " + properties.getMessageId() + " and delivery tag: " + envelope.getDeliveryTag() + " on the queue: " + this.queueName + " will discard."));
            }
        }

        @Override
        public void run() {
            try {
                this.initConsumer();
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while initializing the consumer.", (Throwable)e);
            }
        }

        public void close() {
            ServiceTaskManager.this.connection.abort();
            ServiceTaskManager.this.rabbitMQConnectionPool.returnObject(ServiceTaskManager.this.factoryName, ServiceTaskManager.this.connection);
            this.channel = null;
            ServiceTaskManager.this.connection = null;
        }
    }
}

