/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.rabbitmq.AxisRabbitMQException;
import org.apache.axis2.transport.rabbitmq.RabbitMQChannelFactory;
import org.apache.axis2.transport.rabbitmq.RabbitMQChannelPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQConfirmChannelFactory;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionFactory;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQMessageSender;
import org.apache.axis2.transport.rabbitmq.RabbitMQOutTransportInfo;
import org.apache.axis2.transport.rabbitmq.RabbitMQUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.securevault.SecretResolver;

public class RabbitMQSender
extends AbstractTransportSender {
    private RabbitMQConnectionFactory rabbitMQConnectionFactory;
    private RabbitMQChannelPool rabbitMQChannelPool;
    private RabbitMQChannelPool rabbitMQConfirmChannelPool;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        try {
            super.init(cfgCtx, transportOut);
            SecretResolver secretResolver = cfgCtx.getAxisConfiguration().getSecretResolver();
            this.rabbitMQConnectionFactory = new RabbitMQConnectionFactory();
            int poolSize = RabbitMQUtils.resolveTransportDescription((ParameterInclude)transportOut, secretResolver, this.rabbitMQConnectionFactory);
            RabbitMQConnectionPool rabbitMQConnectionPool = new RabbitMQConnectionPool(this.rabbitMQConnectionFactory, poolSize);
            RabbitMQChannelFactory rabbitMQChannelFactory = new RabbitMQChannelFactory(rabbitMQConnectionPool);
            this.rabbitMQChannelPool = new RabbitMQChannelPool(rabbitMQChannelFactory, poolSize);
            RabbitMQConfirmChannelFactory rabbitMQConfirmChannelFactory = new RabbitMQConfirmChannelFactory(rabbitMQConnectionPool);
            this.rabbitMQConfirmChannelPool = new RabbitMQChannelPool(rabbitMQConfirmChannelFactory, poolSize);
            this.log.info((Object)"RabbitMQ AMQP Transport Sender initialized...");
        }
        catch (AxisRabbitMQException e) {
            throw new AxisFault("Error occurred while initializing the RabbitMQ AMQP Transport Sender.", (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        this.log.info((Object)"RabbitMQ AMQP Transport Sender stopped...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        if (targetEPR != null) {
            RabbitMQOutTransportInfo transportOutInfo = new RabbitMQOutTransportInfo(targetEPR);
            String factoryName = RabbitMQUtils.resolveTransportDescriptionFromTargetEPR(transportOutInfo.getProperties(), this.rabbitMQConnectionFactory);
            Channel channel = null;
            Delivery response = null;
            SenderType senderType = null;
            try {
                Hashtable epProperties = BaseUtils.getEPRProperties((String)targetEPR);
                String queueName = (String)epProperties.get("rabbitmq.queue.name");
                String routingKey = (String)epProperties.get("rabbitmq.queue.routing.key");
                if (StringUtils.isNotEmpty((String)queueName) && StringUtils.isEmpty((String)routingKey)) {
                    routingKey = queueName;
                } else if (StringUtils.isEmpty((String)queueName) && StringUtils.isEmpty((String)routingKey)) {
                    routingKey = targetEPR.substring(targetEPR.indexOf("/") + 1, targetEPR.indexOf("?"));
                }
                senderType = this.getSenderType(msgCtx, epProperties);
                channel = senderType == SenderType.PUBLISHER_CONFIRMS ? this.rabbitMQConfirmChannelPool.borrowObject(factoryName) : this.rabbitMQChannelPool.borrowObject(factoryName);
                RabbitMQMessageSender sender = new RabbitMQMessageSender(channel, factoryName, senderType);
                response = sender.send(routingKey, msgCtx, epProperties);
                this.returnToPool(factoryName, channel, senderType);
            }
            catch (Exception e) {
                this.log.error((Object)"Error occurred while sending message out.", (Throwable)e);
                channel = null;
            }
            finally {
                this.returnToPool(factoryName, channel, senderType);
            }
            if (response != null) {
                MessageContext responseMsgCtx = this.createResponseMessageContext(msgCtx);
                String contentType = RabbitMQUtils.buildMessage(response.getProperties(), response.getBody(), responseMsgCtx);
                this.handleIncomingMessage(responseMsgCtx, RabbitMQUtils.getTransportHeaders(response.getProperties()), RabbitMQUtils.getSoapAction(response.getProperties()), contentType);
            }
        } else if (outTransportInfo instanceof RabbitMQOutTransportInfo) {
            RabbitMQOutTransportInfo transportOutInfo = (RabbitMQOutTransportInfo)outTransportInfo;
            String factoryName = transportOutInfo.getConnectionFactoryName();
            Channel channel = null;
            try {
                Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
                msgCtx.setProperty("rabbitmq.message.correlation.id", transportHeaders.get("rabbitmq.message.correlation.id"));
                String replyTo = (String)transportHeaders.get("RABBITMQ_REPLY_TO");
                HashMap<String, String> rabbitMQProperties = new HashMap<String, String>();
                rabbitMQProperties.put("rabbitmq.queue.autodeclare", "false");
                rabbitMQProperties.put("rabbitmq.exchange.autodeclare", "false");
                channel = this.rabbitMQChannelPool.borrowObject(factoryName);
                RabbitMQMessageSender sender = new RabbitMQMessageSender(channel, factoryName, SenderType.DEFAULT);
                sender.send(replyTo, msgCtx, rabbitMQProperties);
                this.returnToPool(factoryName, channel, SenderType.DEFAULT);
            }
            catch (Exception e) {
                this.log.error((Object)"Error occurred while sending message out.", (Throwable)e);
                channel = null;
            }
            finally {
                this.returnToPool(factoryName, channel, SenderType.DEFAULT);
            }
        }
    }

    private void returnToPool(String factoryName, Channel channel, SenderType senderType) {
        if (senderType == SenderType.PUBLISHER_CONFIRMS) {
            this.rabbitMQConfirmChannelPool.returnObject(factoryName, channel);
        } else {
            this.rabbitMQChannelPool.returnObject(factoryName, channel);
        }
    }

    private SenderType getSenderType(MessageContext messageContext, Map<String, String> epProperties) {
        SenderType type = this.waitForSynchronousResponse(messageContext) ? SenderType.RPC : (BooleanUtils.toBoolean((String)epProperties.get("rabbitmq.publisher.confirms.enabled")) ? SenderType.PUBLISHER_CONFIRMS : SenderType.DEFAULT);
        return type;
    }

    static enum SenderType {
        RPC,
        PUBLISHER_CONFIRMS,
        DEFAULT;

    }
}

