/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabbitMQRecoveryListener
implements RecoveryListener {
    private static final Log log = LogFactory.getLog(RabbitMQRecoveryListener.class);

    public void handleRecovery(Recoverable recoverable) {
        if (recoverable instanceof Connection) {
            String connectionId = ((Connection)recoverable).getId();
            log.info((Object)("Connection with id " + connectionId + " was recovered."));
        }
        if (recoverable instanceof Channel) {
            int channelNumber = ((Channel)recoverable).getChannelNumber();
            log.info((Object)("Connection to channel number " + channelNumber + " was recovered."));
        }
    }

    public void handleRecoveryStarted(Recoverable recoverable) {
        if (recoverable instanceof Connection) {
            String connectionId = ((Connection)recoverable).getId();
            log.info((Object)("Connection with id " + connectionId + " started to recover."));
        }
        if (recoverable instanceof Channel) {
            int channelNumber = ((Channel)recoverable).getChannelNumber();
            log.info((Object)("Connection to channel number " + channelNumber + " started to recover."));
        }
    }
}

