/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.rabbitmq.AxisRabbitMQException;
import org.apache.axis2.transport.rabbitmq.RabbitMQSender;
import org.apache.axis2.transport.rabbitmq.RabbitMQUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabbitMQMessageSender {
    private static final Log log = LogFactory.getLog(RabbitMQMessageSender.class);
    private Channel channel;
    private String factoryName;
    private RabbitMQSender.SenderType senderType;

    public RabbitMQMessageSender(Channel channel, String factoryName, RabbitMQSender.SenderType senderType) {
        this.channel = channel;
        this.senderType = senderType;
        this.factoryName = factoryName;
    }

    public Delivery send(String routingKey, MessageContext msgContext, Map<String, String> rabbitMQProperties) throws IOException, AxisRabbitMQException {
        Delivery response = null;
        String queueName = rabbitMQProperties.get("rabbitmq.queue.name");
        RabbitMQUtils.declareQueue(this.channel, queueName, rabbitMQProperties);
        String exchangeName = rabbitMQProperties.get("rabbitmq.exchange.name");
        RabbitMQUtils.declareExchange(this.channel, exchangeName, rabbitMQProperties);
        AMQP.BasicProperties.Builder builder = this.buildBasicProperties(msgContext);
        int deliveryMode = NumberUtils.toInt((String)rabbitMQProperties.get("rabbitmq.queue.delivery.mode"), (int)2);
        builder.deliveryMode(Integer.valueOf(deliveryMode));
        long replyTimeout = NumberUtils.toLong((String)((String)msgContext.getProperty("RABBITMQ_WAIT_REPLY")), (long)30000L);
        long confirmTimeout = NumberUtils.toLong((String)((String)msgContext.getProperty("RABBITMQ_WAIT_CONFIRMS")), (long)30000L);
        AMQP.BasicProperties basicProperties = builder.build();
        byte[] messageBody = RabbitMQUtils.getMessageBody(msgContext);
        switch (this.senderType) {
            case RPC: {
                response = this.sendRPC(exchangeName, routingKey, basicProperties, messageBody, replyTimeout);
                break;
            }
            case PUBLISHER_CONFIRMS: {
                this.sendPublisherConfirms(exchangeName, routingKey, basicProperties, messageBody, confirmTimeout);
                break;
            }
            default: {
                this.publishMessage(exchangeName, routingKey, basicProperties, messageBody);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Delivery sendRPC(String exchangeName, String routingKey, AMQP.BasicProperties basicProperties, byte[] messageBody, long timeout) throws IOException {
        Delivery response = null;
        String replyTo = basicProperties.getReplyTo();
        ArrayBlockingQueue responses = new ArrayBlockingQueue(1);
        this.publishMessage(exchangeName, routingKey, basicProperties, messageBody);
        String replyConsumerTag = this.channel.basicConsume(replyTo, true, (consumerTag, delivery) -> responses.offer(delivery), consumerTag -> {});
        try {
            response = (Delivery)responses.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.channel.basicCancel(replyConsumerTag);
        }
        if (response == null) {
            log.warn((Object)("Did not receive a response within " + timeout + "ms to the replyTo queue " + replyTo));
        }
        return response;
    }

    private void sendPublisherConfirms(String exchangeName, String routingKey, AMQP.BasicProperties basicProperties, byte[] messageBody, long timeout) throws IOException, AxisRabbitMQException {
        this.publishMessage(exchangeName, routingKey, basicProperties, messageBody);
        try {
            boolean success = this.channel.waitForConfirms(timeout);
            if (!success) {
                throw new AxisRabbitMQException("The message published to the exchange: " + exchangeName + " with the routing key: " + routingKey + " nack'd by the broker.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            throw new AxisRabbitMQException("Did not receive a confirmation within " + timeout + "ms for the message published to the exchange: " + exchangeName + " with the routing key: " + routingKey);
        }
    }

    private void publishMessage(String exchangeName, String routingKey, AMQP.BasicProperties basicProperties, byte[] messageBody) throws IOException {
        if (StringUtils.isNotEmpty((String)exchangeName)) {
            this.channel.basicPublish(exchangeName, routingKey, basicProperties, messageBody);
        } else {
            this.channel.basicPublish("", routingKey, basicProperties, messageBody);
        }
    }

    private AMQP.BasicProperties.Builder buildBasicProperties(MessageContext msgCtx) throws IOException {
        String soapAction;
        String contentEncoding;
        String correlationId;
        String messageId;
        Integer priority;
        String clusterId;
        String appId;
        String userId;
        String expiration;
        String timestamp;
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
        HashMap<String, String> headers = (HashMap<String, String>)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        if (StringUtils.isNotEmpty((String)(timestamp = (String)msgCtx.getProperty("rabbitmq.message.timestamp")))) {
            try {
                builder.timestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(timestamp));
            }
            catch (ParseException e) {
                log.warn((Object)(timestamp + " can not be parsed as a java.util.Date"));
            }
        }
        if ((expiration = (String)msgCtx.getProperty("rabbitmq.message.expiration")) != null) {
            builder.expiration(expiration);
        }
        if ((userId = (String)msgCtx.getProperty("rabbitmq.message.user.id")) != null) {
            builder.userId(userId);
        }
        if ((appId = (String)msgCtx.getProperty("rabbitmq.message.app.id")) != null) {
            builder.appId(appId);
        }
        if ((clusterId = (String)msgCtx.getProperty("rabbitmq.message.cluster.id")) != null) {
            builder.clusterId(clusterId);
        }
        if ((priority = (Integer)msgCtx.getProperty("rabbitmq.message.priority")) != null) {
            builder.priority(priority);
        }
        if ((messageId = msgCtx.getMessageID()) != null) {
            builder.messageId(messageId);
        }
        if ((correlationId = (String)msgCtx.getProperty("rabbitmq.message.correlation.id")) == null || correlationId.isEmpty()) {
            correlationId = messageId;
        }
        builder.correlationId(correlationId);
        String contentType = (String)msgCtx.getProperty("messageType");
        if (contentType != null) {
            builder.contentType(contentType);
        }
        if ((contentEncoding = (String)msgCtx.getProperty("CHARACTER_SET_ENCODING")) != null) {
            builder.contentEncoding(contentEncoding);
        }
        if ((soapAction = msgCtx.getSoapAction()) != null) {
            headers.put("SOAP_ACTION", soapAction);
        }
        if (this.senderType == RabbitMQSender.SenderType.RPC) {
            builder.replyTo(this.channel.queueDeclare().getQueue());
            headers.put("rabbitmq.connection.factory", this.factoryName);
        }
        builder.headers(headers);
        return builder;
    }
}

