/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.AMQP;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.rabbitmq.RabbitMQEndpoint;
import org.apache.axis2.transport.rabbitmq.RabbitMQListener;
import org.apache.axis2.transport.rabbitmq.RabbitMQUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabbitMQMessageReceiver {
    private static final Log log = LogFactory.getLog(RabbitMQMessageReceiver.class);
    private final RabbitMQEndpoint endpoint;
    private final RabbitMQListener listener;

    public RabbitMQMessageReceiver(RabbitMQListener listener, RabbitMQEndpoint endpoint) {
        this.endpoint = endpoint;
        this.listener = listener;
    }

    public boolean onMessage(AMQP.BasicProperties properties, byte[] body) {
        boolean successful = false;
        try {
            successful = this.processThroughAxisEngine(properties, body);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while processing message", (Throwable)axisFault);
        }
        return successful;
    }

    private boolean processThroughAxisEngine(AMQP.BasicProperties properties, byte[] body) throws AxisFault {
        MessageContext msgContext = this.endpoint.createMessageContext();
        String contentType = RabbitMQUtils.buildMessage(properties, body, msgContext);
        try {
            this.listener.handleIncomingMessage(msgContext, RabbitMQUtils.getTransportHeaders(properties), RabbitMQUtils.getSoapAction(properties), contentType);
            Object rollbackProperty = msgContext.getProperty("SET_ROLLBACK_ONLY");
            if (rollbackProperty instanceof Boolean && ((Boolean)rollbackProperty).booleanValue() || rollbackProperty instanceof String && Boolean.parseBoolean((String)rollbackProperty)) {
                return false;
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error when trying to read incoming message ...", (Throwable)axisFault);
            return false;
        }
        return true;
    }
}

