/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.rabbitmq.AxisRabbitMQException;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionFactory;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQEndpoint;
import org.apache.axis2.transport.rabbitmq.RabbitMQUtils;
import org.apache.axis2.transport.rabbitmq.ServiceTaskManager;
import org.wso2.securevault.SecretResolver;

public class RabbitMQListener
extends AbstractTransportListenerEx<RabbitMQEndpoint> {
    private RabbitMQConnectionFactory rabbitMQConnectionFactory;
    private RabbitMQConnectionPool rabbitMQConnectionPool;

    protected void doInit() throws AxisFault {
        try {
            SecretResolver secretResolver = this.getConfigurationContext().getAxisConfiguration().getSecretResolver();
            this.rabbitMQConnectionFactory = new RabbitMQConnectionFactory();
            int poolSize = RabbitMQUtils.resolveTransportDescription((ParameterInclude)this.getTransportInDescription(), secretResolver, this.rabbitMQConnectionFactory);
            this.rabbitMQConnectionPool = new RabbitMQConnectionPool(this.rabbitMQConnectionFactory, poolSize);
            this.log.info((Object)"RabbitMQ AMQP Transport Receiver initialized...");
        }
        catch (AxisRabbitMQException e) {
            throw new AxisFault("Error occurred while initializing the RabbitMQ AMQP Transport Receiver. ", (Throwable)e);
        }
    }

    protected RabbitMQEndpoint createEndpoint() {
        return new RabbitMQEndpoint(this, this.workerPool);
    }

    protected void startEndpoint(RabbitMQEndpoint endpoint) throws AxisFault {
        ServiceTaskManager stm = endpoint.getServiceTaskManager();
        try {
            stm.start();
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while starting the endpoint " + stm.getServiceName(), (Throwable)e);
        }
    }

    protected void stopEndpoint(RabbitMQEndpoint endpoint) {
        ServiceTaskManager stm = endpoint.getServiceTaskManager();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping receiver for for service : " + stm.getServiceName()));
        }
        stm.stop();
        this.log.info((Object)("Stopped listening for AMQP messages to service : " + endpoint.getServiceName()));
    }

    public RabbitMQConnectionPool getRabbitMQConnectionPool() {
        return this.rabbitMQConnectionPool;
    }

    public RabbitMQConnectionFactory getRabbitMQConnectionFactory() {
        return this.rabbitMQConnectionFactory;
    }

    public void pause() throws AxisFault {
    }

    public void resume() throws AxisFault {
    }
}

