/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionFactory;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionPool;
import org.apache.axis2.transport.rabbitmq.RabbitMQListener;
import org.apache.axis2.transport.rabbitmq.RabbitMQMessageReceiver;
import org.apache.axis2.transport.rabbitmq.ServiceTaskManager;

public class RabbitMQEndpoint
extends ProtocolEndpoint {
    private final WorkerPool workerPool;
    private final RabbitMQListener rabbitMQListener;
    private Set<EndpointReference> endpointReferences = new HashSet<EndpointReference>();
    private ServiceTaskManager serviceTaskManager;

    public RabbitMQEndpoint(RabbitMQListener rabbitMQListener, WorkerPool workerPool) {
        this.rabbitMQListener = rabbitMQListener;
        this.workerPool = workerPool;
    }

    public EndpointReference[] getEndpointReferences(AxisService service, String ip) {
        return this.endpointReferences.toArray(new EndpointReference[0]);
    }

    public ServiceTaskManager getServiceTaskManager() {
        return this.serviceTaskManager;
    }

    public void setServiceTaskManager(ServiceTaskManager serviceTaskManager) {
        this.serviceTaskManager = serviceTaskManager;
    }

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        if (!(params instanceof AxisService)) {
            return false;
        }
        AxisService service = (AxisService)params;
        Parameter conFacParam = service.getParameter("rabbitmq.connection.factory");
        if (conFacParam == null) {
            return false;
        }
        String factoryName = (String)conFacParam.getValue();
        this.serviceTaskManager = this.createServiceTaskManager(factoryName, service, this.workerPool);
        this.serviceTaskManager.setRabbitMQMessageReceiver(new RabbitMQMessageReceiver(this.rabbitMQListener, this));
        return true;
    }

    private ServiceTaskManager createServiceTaskManager(String factoryName, AxisService service, WorkerPool workerPool) {
        RabbitMQConnectionFactory rabbitMQConnectionFactory = this.rabbitMQListener.getRabbitMQConnectionFactory();
        RabbitMQConnectionPool rabbitMQConnectionPool = this.rabbitMQListener.getRabbitMQConnectionPool();
        String serviceName = service.getName();
        Map<String, String> serviceParameters = this.getServiceStringParameters(service.getParameters());
        Map<String, String> cfParameters = rabbitMQConnectionFactory.getConnectionFactoryConfiguration(factoryName);
        ServiceTaskManager taskManager = new ServiceTaskManager(rabbitMQConnectionPool, factoryName);
        taskManager.setServiceName(serviceName);
        taskManager.addRabbitMQProperties(cfParameters);
        taskManager.addRabbitMQProperties(serviceParameters);
        taskManager.setWorkerPool(workerPool);
        return taskManager;
    }

    private Map<String, String> getServiceStringParameters(List<Parameter> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter p : list) {
            if (!(p.getValue() instanceof String)) continue;
            map.put(p.getName(), (String)p.getValue());
        }
        return map;
    }
}

