/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.Connection;
import java.util.NoSuchElementException;
import org.apache.axis2.transport.rabbitmq.AxisRabbitMQException;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;

public class RabbitMQConnectionPool
extends GenericKeyedObjectPool<String, Connection> {
    private static final Log log = LogFactory.getLog(RabbitMQConnectionPool.class);

    public RabbitMQConnectionPool(RabbitMQConnectionFactory factory, int poolSize) {
        super((KeyedPooledObjectFactory)factory);
        this.setTestOnBorrow(true);
        this.setMaxTotal(poolSize);
    }

    public Connection borrowObject(String factoryName) throws Exception {
        try {
            return (Connection)super.borrowObject((Object)factoryName);
        }
        catch (NoSuchElementException nse) {
            if (null == nse.getCause()) {
                throw new AxisRabbitMQException("Error occurred while getting a connection of " + factoryName + " since the pool is exhausted", nse);
            }
            throw new AxisRabbitMQException("Error occurred while borrowing a connection " + factoryName, nse);
        }
    }

    public void returnObject(String factoryName, Connection connection) {
        try {
            if (connection != null) {
                if (connection.isOpen()) {
                    super.returnObject((Object)factoryName, (Object)connection);
                } else {
                    super.invalidateObject((Object)factoryName, (Object)connection);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while returning a connection of " + factoryName + " back to the pool"), (Throwable)e);
        }
    }
}

