/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis2.transport.rabbitmq.AxisRabbitMQException;
import org.apache.axis2.transport.rabbitmq.RabbitMQUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class RabbitMQConnectionFactory
extends BaseKeyedPooledObjectFactory<String, Connection> {
    private static final Log log = LogFactory.getLog(RabbitMQConnectionFactory.class);
    private Map<String, Map<String, String>> connectionFactoryConfigurations = new HashMap<String, Map<String, String>>();
    private int retryInterval;
    private int retryCount;
    private Address[] addresses;

    public Connection create(String factoryName) throws Exception {
        Connection connection;
        block3: {
            Map<String, String> parameters = this.connectionFactoryConfigurations.get(factoryName);
            if (null == parameters) {
                throw new AxisRabbitMQException("Configuration parameters not found");
            }
            ConnectionFactory connectionFactory = this.loadConnectionFactory(parameters);
            connection = null;
            try {
                connection = RabbitMQUtils.createConnection(connectionFactory, this.addresses);
                log.info((Object)("[" + factoryName + "] Successfully connected to RabbitMQ Broker"));
            }
            catch (IOException e) {
                log.error((Object)("[" + factoryName + "] Error creating connection to RabbitMQ Broker. Reattempting to connect."), (Throwable)e);
                connection = this.retry(factoryName, connectionFactory, connection);
                if (connection != null) break block3;
                throw new AxisRabbitMQException("[" + factoryName + "] Could not connect to RabbitMQ Broker. Error while creating connection", e);
            }
        }
        return connection;
    }

    private Connection retry(String factoryName, ConnectionFactory connectionFactory, Connection connection) {
        int retryC = 0;
        while (connection == null && (this.retryCount == -1 || retryC < this.retryCount)) {
            ++retryC;
            log.info((Object)("[" + factoryName + "] Attempting to create connection to RabbitMQ Broker in " + this.retryInterval + " ms"));
            try {
                Thread.sleep(this.retryInterval);
                connection = RabbitMQUtils.createConnection(connectionFactory, this.addresses);
                log.info((Object)("[" + factoryName + "] Successfully connected to RabbitMQ Broker"));
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e1) {
                log.error((Object)("[" + factoryName + "] Error while trying to reconnect to RabbitMQ Broker"), (Throwable)e1);
            }
        }
        return connection;
    }

    public PooledObject<Connection> wrap(Connection connection) {
        return new DefaultPooledObject((Object)connection);
    }

    public void destroyObject(String factoryName, PooledObject<Connection> pooledObject) throws Exception {
        ((Connection)pooledObject.getObject()).abort();
    }

    public boolean validateObject(String factoryName, PooledObject<Connection> pooledObject) {
        return ((Connection)pooledObject.getObject()).isOpen();
    }

    public Map<String, Map<String, String>> getConnectionFactoryConfigurations() {
        return this.connectionFactoryConfigurations;
    }

    public Map<String, String> getConnectionFactoryConfiguration(String factoryName) {
        return this.connectionFactoryConfigurations.get(factoryName);
    }

    public void addConnectionFactoryConfiguration(String name, Map<String, String> parameters) {
        this.connectionFactoryConfigurations.put(name, parameters);
    }

    private ConnectionFactory loadConnectionFactory(Map<String, String> parameters) throws AxisRabbitMQException {
        String[] portArray;
        String hostnames = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.host.name"), (String)"localhost");
        String ports = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.port"), (String)String.valueOf(5672));
        String username = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.user.name"), (String)"guest");
        String password = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.password"), (String)"guest");
        String virtualHost = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.virtual.host"), (String)"/");
        int heartbeat = NumberUtils.toInt((String)parameters.get("rabbitmq.connection.factory.heartbeat"), (int)60);
        int connectionTimeout = NumberUtils.toInt((String)parameters.get("rabbitmq.connection.factory.timeout"), (int)60000);
        long networkRecoveryInterval = NumberUtils.toLong((String)parameters.get("rabbitmq.connection.factory.network.recovery.interval"), (long)5000L);
        this.retryInterval = NumberUtils.toInt((String)parameters.get("rabbitmq.connection.retry.interval"), (int)30000);
        this.retryCount = NumberUtils.toInt((String)parameters.get("rabbitmq.connection.retry.count"), (int)3);
        boolean sslEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)parameters.get("rabbitmq.connection.ssl.enabled")), (boolean)false);
        String[] hostnameArray = hostnames.split(",");
        if (hostnameArray.length == (portArray = ports.split(",")).length) {
            this.addresses = new Address[hostnameArray.length];
            for (int i = 0; i < hostnameArray.length; ++i) {
                try {
                    this.addresses[i] = new Address(hostnameArray[i].trim(), Integer.parseInt(portArray[i].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new AxisRabbitMQException("Number format error in port number", e);
                }
            }
        } else {
            throw new AxisRabbitMQException("The number of hostnames must be equal to the number of ports");
        }
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setUsername(username);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setRequestedHeartbeat(heartbeat);
        connectionFactory.setConnectionTimeout(connectionTimeout);
        connectionFactory.setNetworkRecoveryInterval(networkRecoveryInterval);
        connectionFactory.setAutomaticRecoveryEnabled(true);
        connectionFactory.setTopologyRecoveryEnabled(true);
        this.setSSL(parameters, sslEnabled, connectionFactory);
        return connectionFactory;
    }

    private void setSSL(Map<String, String> parameters, boolean sslEnabled, ConnectionFactory connectionFactory) {
        try {
            if (sslEnabled) {
                String keyStoreLocation = parameters.get("rabbitmq.connection.ssl.keystore.location");
                String keyStoreType = parameters.get("rabbitmq.connection.ssl.keystore.type");
                String keyStorePassword = parameters.get("rabbitmq.connection.ssl.keystore.password");
                String trustStoreLocation = parameters.get("rabbitmq.connection.ssl.truststore.location");
                String trustStoreType = parameters.get("rabbitmq.connection.ssl.truststore.type");
                String trustStorePassword = parameters.get("rabbitmq.connection.ssl.truststore.password");
                String sslVersion = parameters.get("rabbitmq.connection.ssl.version");
                if (StringUtils.isEmpty((String)keyStoreLocation) || StringUtils.isEmpty((String)keyStoreType) || StringUtils.isEmpty((String)keyStorePassword) || StringUtils.isEmpty((String)trustStoreLocation) || StringUtils.isEmpty((String)trustStoreType) || StringUtils.isEmpty((String)trustStorePassword)) {
                    log.info((Object)"Trustore and keystore information is not provided");
                    if (StringUtils.isNotEmpty((String)sslVersion)) {
                        connectionFactory.useSslProtocol(sslVersion);
                    } else {
                        log.info((Object)"Proceeding with default SSL configuration");
                        connectionFactory.useSslProtocol();
                    }
                } else {
                    char[] keyPassphrase = keyStorePassword.toCharArray();
                    KeyStore ks = KeyStore.getInstance(keyStoreType);
                    ks.load(new FileInputStream(keyStoreLocation), keyPassphrase);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, keyPassphrase);
                    char[] trustPassphrase = trustStorePassword.toCharArray();
                    KeyStore tks = KeyStore.getInstance(trustStoreType);
                    tks.load(new FileInputStream(trustStoreLocation), trustPassphrase);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    tmf.init(tks);
                    SSLContext c = SSLContext.getInstance(sslVersion);
                    c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                    connectionFactory.useSslProtocol(c);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Format error in SSL enabled value. Proceeding without enabling SSL", (Throwable)e);
        }
    }
}

