/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import java.util.NoSuchElementException;
import org.apache.axis2.transport.rabbitmq.AxisRabbitMQException;
import org.apache.axis2.transport.rabbitmq.RabbitMQChannelFactory;
import org.apache.axis2.transport.rabbitmq.RabbitMQConfirmChannelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;

public class RabbitMQChannelPool
extends GenericKeyedObjectPool<String, Channel> {
    private static final Log log = LogFactory.getLog(RabbitMQChannelPool.class);

    public RabbitMQChannelPool(RabbitMQChannelFactory rabbitMQChannelFactory, int poolSize) {
        super((KeyedPooledObjectFactory)rabbitMQChannelFactory);
        this.setTestOnBorrow(true);
        this.setMaxTotal(poolSize);
    }

    public RabbitMQChannelPool(RabbitMQConfirmChannelFactory rabbitMQConfirmChannelFactory, int poolSize) {
        super((KeyedPooledObjectFactory)rabbitMQConfirmChannelFactory);
        this.setTestOnBorrow(true);
        this.setMaxTotal(poolSize);
    }

    public Channel borrowObject(String factoryName) throws Exception {
        try {
            return (Channel)super.borrowObject((Object)factoryName);
        }
        catch (NoSuchElementException nse) {
            if (null == nse.getCause()) {
                throw new AxisRabbitMQException("Error occurred while getting a channel of " + factoryName + " since the pool is exhausted", nse);
            }
            throw new AxisRabbitMQException("Error occurred while borrowing a channel of " + factoryName, nse);
        }
    }

    public void returnObject(String factoryName, Channel channel) {
        try {
            if (channel != null) {
                if (channel.isOpen()) {
                    super.returnObject((Object)factoryName, (Object)channel);
                } else {
                    super.invalidateObject((Object)factoryName, (Object)channel);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while returning a channel of " + factoryName + " back to the pool"), (Throwable)e);
        }
    }
}

