/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import org.apache.axis2.transport.rabbitmq.RabbitMQConnectionPool;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class RabbitMQChannelFactory
extends BaseKeyedPooledObjectFactory<String, Channel> {
    private RabbitMQConnectionPool rabbitMQConnectionPool;

    public RabbitMQChannelFactory(RabbitMQConnectionPool rabbitMQConnectionPool) {
        this.rabbitMQConnectionPool = rabbitMQConnectionPool;
    }

    public Channel create(String factoryName) throws Exception {
        Connection connection = this.rabbitMQConnectionPool.borrowObject(factoryName);
        Channel channel = connection.createChannel();
        this.rabbitMQConnectionPool.returnObject(factoryName, connection);
        return channel;
    }

    public PooledObject<Channel> wrap(Channel channel) {
        return new DefaultPooledObject((Object)channel);
    }

    public void destroyObject(String factoryName, PooledObject<Channel> pooledObject) throws Exception {
        ((Channel)pooledObject.getObject()).abort();
    }

    public boolean validateObject(String factoryName, PooledObject<Channel> pooledObject) {
        return ((Channel)pooledObject.getObject()).isOpen();
    }
}

