/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.cassandra;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.output.adapter.cassandra.CassandraEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;

public class CassandraEventAdapterFactory
extends OutputEventAdapterFactory {
    private static final Log log = LogFactory.getLog(CassandraEventAdapterFactory.class);
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.cassandra.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "cassandra";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("map");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property hosts = new Property("hosts");
        hosts.setDisplayName(this.resourceBundle.getString("hosts"));
        hosts.setRequired(true);
        hosts.setHint(this.resourceBundle.getString("hosts.hint"));
        propertyList.add(hosts);
        Property port = new Property("port");
        port.setDisplayName(this.resourceBundle.getString("port"));
        port.setHint(this.resourceBundle.getString("port.hint"));
        propertyList.add(port);
        Property userName = new Property("user.name");
        userName.setDisplayName(this.resourceBundle.getString("user.name"));
        propertyList.add(userName);
        Property password = new Property("password");
        password.setDisplayName(this.resourceBundle.getString("password"));
        password.setSecured(true);
        password.setEncrypted(true);
        propertyList.add(password);
        Property keySpace = new Property("key.space.name");
        keySpace.setDisplayName(this.resourceBundle.getString("key.space.name"));
        keySpace.setRequired(true);
        propertyList.add(keySpace);
        Property columnFamily = new Property("column.family.name");
        columnFamily.setDisplayName(this.resourceBundle.getString("column.family.name"));
        columnFamily.setRequired(true);
        propertyList.add(columnFamily);
        Property strategyClass = new Property("strategy.class");
        strategyClass.setDisplayName(this.resourceBundle.getString("strategy.class"));
        strategyClass.setHint(this.resourceBundle.getString("strategy.class.hint"));
        propertyList.add(strategyClass);
        Property replicationFactor = new Property("replication.factor");
        replicationFactor.setDisplayName(this.resourceBundle.getString("replication.factor"));
        replicationFactor.setHint(this.resourceBundle.getString("replication.factor.hint"));
        propertyList.add(replicationFactor);
        Property indexedColumns = new Property("indexed.columns");
        indexedColumns.setDisplayName(this.resourceBundle.getString("indexed.columns"));
        indexedColumns.setHint(this.resourceBundle.getString("indexed.columns.hint"));
        propertyList.add(indexedColumns);
        return propertyList;
    }

    public List<Property> getDynamicPropertyList() {
        return null;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new CassandraEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

