/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.cassandra;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.prettyprint.cassandra.model.BasicColumnDefinition;
import me.prettyprint.cassandra.model.BasicColumnFamilyDefinition;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;

public class CassandraEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(CassandraEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private Map<String, String> credentials = null;
    private String columnFamilyName;
    private Mutator<String> mutator;
    private Cluster cluster;
    private int tenantId;

    public CassandraEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init() throws OutputEventAdapterException {
        this.validateOutputEventAdapterConfigurations();
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnect() {
        Map staticProperties = this.eventAdapterConfiguration.getStaticProperties();
        String clusterName = "EventPublisher_" + this.eventAdapterConfiguration.getName();
        CassandraHostConfigurator chc = new CassandraHostConfigurator();
        chc.setHosts((String)staticProperties.get("hosts"));
        if (staticProperties.get("port") != null) {
            chc.setPort(Integer.parseInt((String)staticProperties.get("port")));
        }
        Cluster cluster = HFactory.createCluster((String)clusterName, (CassandraHostConfigurator)chc, this.credentials);
        try {
            Set knownPools = cluster.getKnownPoolHosts(true);
            if (knownPools == null || knownPools.size() == 0) {
                throw new ConnectionUnavailableException("Couldn't connect to Cassandra cluster no known hosts found");
            }
        }
        finally {
            HFactory.shutdownCluster((Cluster)cluster);
        }
    }

    public void connect() {
        String indexColumnsString;
        Map staticProperties = this.eventAdapterConfiguration.getStaticProperties();
        String clusterName = "EventPublisher_" + this.eventAdapterConfiguration.getName();
        CassandraHostConfigurator chc = new CassandraHostConfigurator();
        chc.setHosts((String)staticProperties.get("hosts"));
        if (staticProperties.get("port") != null) {
            chc.setPort(Integer.parseInt((String)staticProperties.get("port")));
        }
        this.cluster = HFactory.createCluster((String)clusterName, (CassandraHostConfigurator)chc, this.credentials);
        if (this.cluster.getKnownPoolHosts(true).size() < 1) {
            throw new ConnectionUnavailableException("Cannot connect to the Cassandra cluster '" + this.cluster.getName() + "' from Output Cassandra Adapter '" + this.eventAdapterConfiguration.getName() + "'");
        }
        String keySpaceName = (String)staticProperties.get("key.space.name");
        Keyspace keyspace = HFactory.createKeyspace((String)keySpaceName, (Cluster)this.cluster);
        this.columnFamilyName = (String)staticProperties.get("column.family.name");
        BasicColumnFamilyDefinition columnFamilyDefinition = new BasicColumnFamilyDefinition();
        columnFamilyDefinition.setKeyspaceName(keySpaceName);
        columnFamilyDefinition.setName(this.columnFamilyName);
        columnFamilyDefinition.setComparatorType(ComparatorType.UTF8TYPE);
        columnFamilyDefinition.setDefaultValidationClass(ComparatorType.UTF8TYPE.getClassName());
        columnFamilyDefinition.setKeyValidationClass(ComparatorType.UTF8TYPE.getClassName());
        String strategy = (String)staticProperties.get("strategy.class");
        if (strategy == null) {
            strategy = "org.apache.cassandra.locator.SimpleStrategy";
        }
        if ((indexColumnsString = (String)staticProperties.get("indexed.columns")) != null && !indexColumnsString.isEmpty()) {
            String[] indexedColumns;
            for (String key : indexedColumns = indexColumnsString.split(",")) {
                BasicColumnDefinition columnDefinition = new BasicColumnDefinition();
                columnDefinition.setName(StringSerializer.get().toByteBuffer(key));
                columnDefinition.setIndexType(ColumnIndexType.KEYS);
                columnDefinition.setIndexName(keySpaceName + "_" + this.columnFamilyName + "_" + key + "_Index");
                columnDefinition.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
                columnFamilyDefinition.addColumnDefinition((ColumnDefinition)columnDefinition);
            }
        }
        int replicationFactor = 1;
        String replicationFactorString = (String)staticProperties.get("replication.factor");
        if (replicationFactorString != null) {
            replicationFactor = Integer.parseInt(replicationFactorString);
        }
        ThriftCfDef cfDef = new ThriftCfDef((ColumnFamilyDefinition)columnFamilyDefinition);
        KeyspaceDefinition existingKeyspaceDefinition = this.cluster.describeKeyspace(keySpaceName);
        if (existingKeyspaceDefinition == null) {
            this.cluster.addKeyspace(HFactory.createKeyspaceDefinition((String)keySpaceName, (String)strategy, (int)replicationFactor, Arrays.asList(cfDef)));
        } else {
            ColumnFamilyDefinition existingColumnFamilyDefinition = null;
            for (ColumnFamilyDefinition cfd : existingKeyspaceDefinition.getCfDefs()) {
                if (!cfd.getName().equals(cfDef.getName())) continue;
                existingColumnFamilyDefinition = cfd;
                break;
            }
            if (existingColumnFamilyDefinition == null) {
                this.cluster.addColumnFamily((ColumnFamilyDefinition)cfDef);
            } else {
                this.cluster.updateColumnFamily((ColumnFamilyDefinition)cfDef);
            }
        }
        this.mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)new StringSerializer());
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        if (message instanceof Map) {
            String uuid = UUID.randomUUID().toString();
            try {
                for (Map.Entry entry : ((Map)message).entrySet()) {
                    this.mutator.insert((Object)uuid, this.columnFamilyName, HFactory.createStringColumn((String)((String)entry.getKey()), (String)entry.getValue().toString()));
                }
                this.mutator.execute();
            }
            catch (Throwable t) {
                EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, null, (Throwable)t, (Log)log, (int)this.tenantId);
            }
        } else {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Event is not type of Map.", (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        if (this.cluster != null) {
            HFactory.shutdownCluster((Cluster)this.cluster);
            this.cluster = null;
        }
    }

    public void destroy() {
        this.credentials = null;
    }

    public boolean isPolled() {
        return false;
    }

    private void validateOutputEventAdapterConfigurations() throws OutputEventAdapterException {
        String replicationFactorProperty;
        Map staticProperties = this.eventAdapterConfiguration.getStaticProperties();
        String username = (String)staticProperties.get("user.name");
        String password = (String)staticProperties.get("password");
        if (username != null && password != null) {
            this.credentials = new HashMap<String, String>();
            this.credentials.put("username", username);
            this.credentials.put("password", password);
        } else if (username != null || password != null) {
            throw new OutputEventAdapterException("Both username & password properties should be null or not null for Cassandra Output Adapter '" + this.eventAdapterConfiguration.getName() + "'");
        }
        String portProperty = (String)staticProperties.get("port");
        if (portProperty != null) {
            try {
                Integer.parseInt(portProperty);
            }
            catch (NumberFormatException e) {
                throw new OutputEventAdapterException("Invalid value set for property 'Port': " + portProperty, (Throwable)e);
            }
        }
        if ((replicationFactorProperty = (String)staticProperties.get("replication.factor")) != null) {
            try {
                Integer.parseInt(replicationFactorProperty);
            }
            catch (NumberFormatException e) {
                throw new OutputEventAdapterException("Invalid value set for property 'Replication Factor': " + replicationFactorProperty, (Throwable)e);
            }
        }
    }
}

