/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.cache.invalidation;

import javax.jms.MessageListener;
import org.wso2.carbon.apimgt.cache.invalidation.APIMgtCacheInvalidationListener;
import org.wso2.carbon.apimgt.cache.invalidation.internal.DataHolder;
import org.wso2.carbon.apimgt.common.jms.JMSTransportHandler;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupObserver;

public class APIMgtServerStartupListener
implements ServerStartupObserver,
ServerShutdownHandler {
    private JMSTransportHandler jmsTransportHandlerForEventHub;

    public APIMgtServerStartupListener() {
        EventHubConfigurationDto.EventHubReceiverConfiguration eventHubReceiverConfiguration = DataHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getEventHubConfigurationDto().getEventHubReceiverConfiguration();
        if (eventHubReceiverConfiguration != null) {
            this.jmsTransportHandlerForEventHub = new JMSTransportHandler(eventHubReceiverConfiguration.getJmsConnectionParameters());
        }
    }

    public void completingServerStartup() {
    }

    public void completedServerStartup() {
        if (DataHolder.getInstance().getCacheInvalidationConfiguration() != null && DataHolder.getInstance().getCacheInvalidationConfiguration().isEnabled() && this.jmsTransportHandlerForEventHub != null) {
            this.jmsTransportHandlerForEventHub.subscribeForJmsEvents("globalCacheInvalidation", (MessageListener)new APIMgtCacheInvalidationListener(DataHolder.getInstance().getCacheInvalidationConfiguration()));
            DataHolder.getInstance().setStarted(true);
        }
    }

    public void invoke() {
        if (DataHolder.getInstance().getCacheInvalidationConfiguration() != null && DataHolder.getInstance().getCacheInvalidationConfiguration().isEnabled() && this.jmsTransportHandlerForEventHub != null) {
            this.jmsTransportHandlerForEventHub.unSubscribeFromEvents();
            DataHolder.getInstance().setStarted(false);
        }
    }
}

