/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.cache.invalidation;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import javax.cache.CacheEntryInfo;
import javax.cache.CacheInvalidationRequestSender;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.wso2.carbon.apimgt.cache.invalidation.internal.DataHolder;
import org.wso2.carbon.apimgt.impl.CacheInvalidationConfiguration;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.caching.impl.Util;
import org.wso2.carbon.databridge.commons.Event;

public class APIMgtCacheInvalidationRequestSender
implements CacheEntryRemovedListener,
CacheEntryUpdatedListener,
CacheEntryCreatedListener,
CacheInvalidationRequestSender {
    CacheInvalidationConfiguration cacheInvalidationConfiguration;

    public APIMgtCacheInvalidationRequestSender(CacheInvalidationConfiguration cacheInvalidationConfiguration) {
        this.cacheInvalidationConfiguration = cacheInvalidationConfiguration;
    }

    public void send(CacheEntryInfo cacheInfo) {
        if (this.cacheInvalidationConfiguration.isEnabled() && DataHolder.getInstance().isStarted()) {
            boolean excludedCachePresent = false;
            for (String excludedCache : this.cacheInvalidationConfiguration.getExcludedCaches()) {
                if (!cacheInfo.getCacheName().contains(excludedCache)) continue;
                excludedCachePresent = true;
                break;
            }
            if (!excludedCachePresent) {
                Object[] objects = new Object[]{cacheInfo.getCacheManagerName(), cacheInfo.getCacheName(), this.constructCacheKeyString(cacheInfo.getCacheKey()), cacheInfo.getTenantDomain(), cacheInfo.getTenantId(), this.cacheInvalidationConfiguration.getDomain(), DataHolder.getNodeId()};
                Event cacheInvalidationMessage = new Event(this.cacheInvalidationConfiguration.getStream(), System.currentTimeMillis(), null, null, objects);
                APIUtil.publishEventToEventHub(Collections.emptyMap(), (Event)cacheInvalidationMessage);
            }
        }
    }

    public void entryCreated(CacheEntryEvent cacheEntryEvent) throws CacheEntryListenerException {
    }

    public void entryRemoved(CacheEntryEvent cacheEntryEvent) throws CacheEntryListenerException {
        this.send(Util.createCacheInfo((CacheEntryEvent)cacheEntryEvent));
    }

    public void entryUpdated(CacheEntryEvent cacheEntryEvent) throws CacheEntryListenerException {
        this.send(Util.createCacheInfo((CacheEntryEvent)cacheEntryEvent));
    }

    private String constructCacheKeyString(Object cacheKey) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", cacheKey.getClass().getName());
        String jsonString = new Gson().toJson(cacheKey);
        jsonObject.add("value", new JsonParser().parse(jsonString));
        return jsonObject.toString();
    }
}

