/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.cache.invalidation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.cache.invalidation.internal.DataHolder;
import org.wso2.carbon.apimgt.impl.CacheInvalidationConfiguration;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class APIMgtCacheInvalidationListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(APIMgtCacheInvalidationListener.class);
    private final CacheInvalidationConfiguration cacheInvalidationConfiguration;

    public APIMgtCacheInvalidationListener(CacheInvalidationConfiguration cacheInvalidationConfiguration) {
        this.cacheInvalidationConfiguration = cacheInvalidationConfiguration;
    }

    public void onMessage(Message message) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (this.cacheInvalidationConfiguration.getCacheInValidationTopic().equalsIgnoreCase(jmsDestination.getTopicName())) {
                    if (message instanceof MapMessage) {
                        MapMessage mapMessage = (MapMessage)message;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        Enumeration enumeration = mapMessage.getMapNames();
                        while (enumeration.hasMoreElements()) {
                            String key = (String)enumeration.nextElement();
                            map.put(key, mapMessage.getObject(key));
                        }
                        this.handleCacheInvalidationMessage(map);
                    } else {
                        log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                    }
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCacheInvalidationMessage(Map map) {
        String cacheManagerName = (String)map.get("cacheManagerName");
        String cacheName = (String)map.get("cacheName");
        String cacheKey = (String)map.get("cacheKey");
        String tenantDomain = (String)map.get("tenantDomain");
        int tenantId = (Integer)map.get("tenantId");
        String clusterDomain = (String)map.get("clusterDomain");
        String nodeId = (String)map.get("nodeId");
        if (!DataHolder.getNodeId().equals(nodeId) && this.cacheInvalidationConfiguration.getDomain().equals(clusterDomain)) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(tenantId);
                carbonContext.setTenantDomain(tenantDomain);
                CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(cacheManagerName);
                Cache cache = cacheManager.getCache(cacheName);
                Object cacheKeyObject = this.constructCacheKeyObject(cacheKey);
                if (cache instanceof CacheImpl) {
                    if ("$__clear__all__$.".equals(cacheKeyObject)) {
                        ((CacheImpl)cache).removeAllLocal();
                    } else {
                        ((CacheImpl)cache).removeLocal(cacheKeyObject);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Error while removing cache Object", (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private Object constructCacheKeyObject(String cacheKey) throws ClassNotFoundException {
        JsonElement parsedValue = new JsonParser().parse(cacheKey);
        if (parsedValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)parsedValue;
            String type = jsonObject.get("type").getAsString();
            JsonElement value = jsonObject.get("value");
            return new Gson().fromJson(value, Class.forName(type));
        }
        return null;
    }
}

