/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.tokenmgt.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.Caching;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSAnyImpl;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.oauth2.OAuth2ScopeService;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.core.tokenmgt.TokenMgtException;
import org.wso2.is.key.manager.core.tokenmgt.util.CacheProvider;

public class TokenMgtUtil {
    private static final Log log = LogFactory.getLog(TokenMgtUtil.class);
    private static final String AUTHENTICATOR_NAME = "SAML2SSOAuthenticator";

    public static String[] getRolesFromAssertion(Assertion assertion) {
        ArrayList<String> roles = new ArrayList<String>();
        String roleClaim = TokenMgtUtil.getRoleClaim();
        List attributeStatementList = assertion.getAttributeStatements();
        if (attributeStatementList != null) {
            for (AttributeStatement statement : attributeStatementList) {
                List attributesList = statement.getAttributes();
                for (Attribute attribute : attributesList) {
                    String attributeName = attribute.getName();
                    if (attributeName == null || !roleClaim.equals(attributeName)) continue;
                    List attributeValues = attribute.getAttributeValues();
                    if (attributeValues != null && attributeValues.size() == 1) {
                        String attributeValueString = TokenMgtUtil.getAttributeValue((XMLObject)attributeValues.get(0));
                        String multiAttributeSeparator = TokenMgtUtil.getAttributeSeparator();
                        Object[] attributeValuesArray = attributeValueString.split(multiAttributeSeparator);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding attributes for Assertion: " + assertion + " AttributeName : " + attributeName + ", AttributeValue : " + Arrays.toString(attributeValuesArray)));
                        }
                        roles.addAll(Arrays.asList(attributeValuesArray));
                        continue;
                    }
                    if (attributeValues == null || attributeValues.size() <= 1) continue;
                    for (XMLObject attributeValue : attributeValues) {
                        String attributeValueString = TokenMgtUtil.getAttributeValue(attributeValue);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding attributes for Assertion: " + assertion + " AttributeName : " + attributeName + ", AttributeValue : " + attributeValue));
                        }
                        roles.add(attributeValueString);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Role list found for assertion: " + assertion + ", roles: " + roles));
        }
        return roles.toArray(new String[roles.size()]);
    }

    private static String getAttributeValue(XMLObject attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof XSString) {
            return TokenMgtUtil.getStringAttributeValue((XSString)attributeValue);
        }
        if (attributeValue instanceof XSAnyImpl) {
            return TokenMgtUtil.getAnyAttributeValue((XSAnyImpl)attributeValue);
        }
        return attributeValue.toString();
    }

    private static String getStringAttributeValue(XSString attributeValue) {
        return attributeValue.getValue();
    }

    private static String getAnyAttributeValue(XSAnyImpl attributeValue) {
        return attributeValue.getTextContent();
    }

    private static String getAttributeSeparator() {
        Map configParameters;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (configParameters = authenticatorConfig.getParameters()).containsKey("AttributeValueSeparator")) {
            return (String)configParameters.get("AttributeValueSeparator");
        }
        return ",";
    }

    private static String getRoleClaim() {
        Map configParameters;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (configParameters = authenticatorConfig.getParameters()).containsKey("RoleClaimAttribute")) {
            return (String)configParameters.get("RoleClaimAttribute");
        }
        return "http://wso2.org/claims/role";
    }

    public static OAuth2ScopeService getOAuth2ScopeService() {
        return (OAuth2ScopeService)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(OAuth2ScopeService.class, null);
    }

    public static Map<String, String> getRESTAPIScopesForTenant(String tenantDomain) throws TokenMgtException {
        CacheProvider.getInstance();
        Map<String, String> restAPIScopes = (Map<String, String>)CacheProvider.getRESTAPIScopeCache().get((Object)tenantDomain);
        if (restAPIScopes == null) {
            restAPIScopes = TokenMgtUtil.getRESTAPIScopesFromConfig(TokenMgtUtil.getTenantRESTAPIScopesConfig(tenantDomain), TokenMgtUtil.getTenantRESTAPIScopeRoleMappingsConfig(tenantDomain));
            Caching.getCacheManager((String)"EXTENTIONS_CACHE_MANAGER").getCache("REST_API_SCOPE_CACHE").put((Object)tenantDomain, restAPIScopes);
        }
        return restAPIScopes;
    }

    public static Map<String, String> getRESTAPIScopesFromConfig(JSONObject scopesConfig, JSONObject roleMappings) {
        HashMap<String, String> scopes = new HashMap<String, String>();
        if (scopesConfig != null) {
            JSONArray scopesArray = (JSONArray)scopesConfig.get((Object)"Scope");
            for (Object scopeObj : scopesArray) {
                JSONObject scope = (JSONObject)scopeObj;
                String scopeName = scope.get((Object)"Name").toString();
                String scopeRoles = scope.get((Object)"Roles").toString();
                if (roleMappings != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"REST API scope role mappings exist. Hence proceeding to swap original scope roles for mapped scope roles.");
                    }
                    List<String> originalRoles = Arrays.asList(scopeRoles.split("\\s*,\\s*"));
                    ArrayList<String> mappedRoles = new ArrayList<String>();
                    for (String role : originalRoles) {
                        String mappedRole = (String)roleMappings.get((Object)role);
                        if (mappedRole != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(role + " was mapped to " + mappedRole));
                            }
                            mappedRoles.add(mappedRole);
                            continue;
                        }
                        mappedRoles.add(role);
                    }
                    scopeRoles = String.join((CharSequence)",", mappedRoles);
                }
                scopes.put(scopeName, scopeRoles);
            }
        }
        return scopes;
    }

    public static JSONObject getTenantRESTAPIScopesConfig(String tenantDomain) throws TokenMgtException {
        JSONObject restAPIConfigJSON = null;
        JSONObject tenantConfJson = TokenMgtUtil.getTenantConfig(tenantDomain);
        if (tenantConfJson != null && (restAPIConfigJSON = TokenMgtUtil.getRESTAPIScopesFromTenantConfig(tenantConfJson)) == null) {
            throw new TokenMgtException("RESTAPIScopes config does not exist for tenant " + tenantDomain);
        }
        return restAPIConfigJSON;
    }

    public static JSONObject getTenantRESTAPIScopeRoleMappingsConfig(String tenantDomain) throws TokenMgtException {
        JSONObject restAPIConfigJSON = null;
        JSONObject tenantConfJson = TokenMgtUtil.getTenantConfig(tenantDomain);
        if (tenantConfJson != null && (restAPIConfigJSON = TokenMgtUtil.getRESTAPIScopeRoleMappingsFromTenantConfig(tenantConfJson)) == null && log.isDebugEnabled()) {
            log.debug((Object)("No REST API role mappings are defined for the tenant " + tenantDomain));
        }
        return restAPIConfigJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getTenantConfig(String tenantDomain) throws TokenMgtException {
        int tenantId = TokenMgtUtil.getTenantIdFromTenantDomain(tenantDomain);
        boolean tenantFlowStarted = false;
        try {
            CacheProvider.getInstance();
            Cache tenantConfigCache = CacheProvider.getTenantConfigCache();
            String cacheName = tenantId + "_" + "tenantConfigCache";
            if (tenantConfigCache.containsKey((Object)cacheName)) {
                return (JSONObject)tenantConfigCache.get((Object)cacheName);
            }
            Resource resource = null;
            if (tenantId != -1234) {
                TokenMgtUtil.loadTenantRegistry(tenantId);
            }
            try {
                PrivilegedCarbonContext.startTenantFlow();
                tenantFlowStarted = true;
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(tenantDomain);
                carbonContext.setTenantId(tenantId);
                RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
                UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
                if (registry.resourceExists("/apimgt/applicationdata/tenant-conf.json")) {
                    resource = registry.get("/apimgt/applicationdata/tenant-conf.json");
                }
            }
            finally {
                if (tenantFlowStarted) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
            if (resource != null) {
                String content = new String((byte[])resource.getContent(), Charset.defaultCharset());
                JSONParser parser = new JSONParser();
                JSONObject tenantConfig = (JSONObject)parser.parse(content);
                tenantConfigCache.put((Object)cacheName, (Object)tenantConfig);
                return tenantConfig;
            }
            return null;
        }
        catch (ParseException | RegistryException e) {
            throw new TokenMgtException("Error while getting tenant config from registry for tenant: " + tenantId, e);
        }
    }

    public static void loadTenantRegistry(int tenantId) throws RegistryException {
        TenantRegistryLoader tenantRegistryLoader = ServiceReferenceHolder.getInstance().getTenantRegistryLoader();
        tenantRegistryLoader.loadTenantRegistry(tenantId);
    }

    public static void loadTenantConfigBlockingMode(String tenantDomain) {
        try {
            ConfigurationContext ctx = ServiceReferenceHolder.getContextService().getServerConfigContext();
            TenantAxisUtils.getTenantAxisConfiguration((String)tenantDomain, (ConfigurationContext)ctx);
        }
        catch (Exception e) {
            log.error((Object)("Error while creating axis configuration for tenant " + tenantDomain), (Throwable)e);
        }
    }

    public static int getTenantIdFromTenantDomain(String tenantDomain) {
        RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
        if (realmService == null || tenantDomain == null) {
            return -1234;
        }
        try {
            return realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Failed to get the Tenant Id of the the Tenant Domain : " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            return -1;
        }
    }

    private static JSONObject getRESTAPIScopesFromTenantConfig(JSONObject tenantConf) {
        return (JSONObject)tenantConf.get((Object)"RESTAPIScopes");
    }

    private static JSONObject getRESTAPIScopeRoleMappingsFromTenantConfig(JSONObject tenantConf) {
        return (JSONObject)tenantConf.get((Object)"RoleMappings");
    }
}

