/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.tokenmgt.issuers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.callback.OAuthCallback;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.bean.ScopeBinding;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.core.tokenmgt.TokenMgtException;
import org.wso2.is.key.manager.core.tokenmgt.util.TokenMgtUtil;

public abstract class AbstractScopesIssuer {
    private static final String DEFAULT_SCOPE_NAME = "default";
    private static Log log = LogFactory.getLog(AbstractScopesIssuer.class);

    public abstract List<String> getScopes(OAuthTokenReqMessageContext var1);

    public abstract List<String> getScopes(OAuthCallback var1);

    public abstract String getPrefix();

    public List<String> getAllowedScopes(List<String> requestedScopes) {
        if (requestedScopes.isEmpty()) {
            requestedScopes.add(DEFAULT_SCOPE_NAME);
        }
        return requestedScopes;
    }

    public boolean isWhiteListedScope(List<String> scopeSkipList, String scope) {
        for (String scopeTobeSkipped : scopeSkipList) {
            if (!scope.matches(scopeTobeSkipped)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAppScopes(String consumerKey, AuthenticatedUser authenticatedUser, List<String> requestedScopes) {
        boolean isTenantFlowStarted = false;
        Map<String, String> appScopes = null;
        Set scopes = null;
        String requestedScopesString = String.join((CharSequence)" ", requestedScopes);
        String tenantDomain = authenticatedUser.isFederatedUser() ? MultitenantUtils.getTenantDomain((String)authenticatedUser.getAuthenticatedSubjectIdentifier()) : authenticatedUser.getTenantDomain();
        if (!"carbon.super".equals(tenantDomain)) {
            isTenantFlowStarted = true;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            TokenMgtUtil.loadTenantConfigBlockingMode(tenantDomain);
        }
        try {
            scopes = TokenMgtUtil.getOAuth2ScopeService().getScopes(null, null, Boolean.valueOf(true), requestedScopesString);
        }
        catch (IdentityOAuth2ScopeServerException e) {
            log.error((Object)("Error while getting scopes " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        if (scopes != null) {
            appScopes = this.getAppScopes(scopes);
        }
        try {
            Map<String, String> restAPIScopes = TokenMgtUtil.getRESTAPIScopesForTenant(tenantDomain);
            if (!restAPIScopes.isEmpty()) {
                appScopes.putAll(restAPIScopes);
            }
        }
        catch (TokenMgtException e) {
            log.error((Object)("Error while getting scopes of application " + e.getMessage()), (Throwable)e);
        }
        return appScopes;
    }

    private Map<String, String> getAppScopes(Set<Scope> scopes) {
        HashMap<String, String> appScopes = new HashMap<String, String>();
        for (Scope scope : scopes) {
            ScopeBinding scopeBinding = this.getScopeBinding(scope.getScopeBindings());
            String bindings = "";
            if (scopeBinding != null) {
                bindings = String.join((CharSequence)",", scopeBinding.getBindings());
            }
            appScopes.put(scope.getName(), bindings);
        }
        return appScopes;
    }

    private ScopeBinding getScopeBinding(List<ScopeBinding> scopeBindings) {
        for (ScopeBinding scopeBinding : scopeBindings) {
            if (!DEFAULT_SCOPE_NAME.equalsIgnoreCase(scopeBinding.getBindingType())) continue;
            return scopeBinding;
        }
        return null;
    }

    public Boolean isAppScopesEmpty(Map<String, String> appScopes, String clientId) {
        if (appScopes.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No scopes defined for the Application " + clientId));
            }
            return true;
        }
        return false;
    }

    protected CacheManager getCacheManager(String name) {
        return Caching.getCacheManager((String)name);
    }

    protected RealmService getRealmService() {
        return ServiceReferenceHolder.getInstance().getRealmService();
    }

    protected int getTenantIdOfUser(String username) {
        return IdentityTenantUtil.getTenantIdOfUser((String)username);
    }
}

