/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.observers;

import java.util.HashMap;
import java.util.Random;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;

public class ReservedUserCreationObserver
extends AbstractAxis2ConfigurationContextObserver
implements ServerStartupObserver {
    private static final Log log = LogFactory.getLog(ReservedUserCreationObserver.class);
    private static final String DEFAULT_RESERVED_USERNAME = "apim_reserved_user";
    private static final String EVERYONE_ROLE = "internal/everyone";
    private static final String USERSTORE_USERNALE_VALIDATION_EXCEPTION_CODE = "31301";

    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        this.createReservedUser();
    }

    public void createReservedUser() {
        block6: {
            try {
                RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
                int tenantId = this.getTenantId();
                if (realmService == null || tenantId == -1) break block6;
                UserStoreManager userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
                if (userStoreManager.isReadOnly()) {
                    log.warn((Object)"Unable to create the reserved user. Please create a user by the name: apim_reserved_user in the user store.");
                    return;
                }
                boolean isReservedUserCreated = userStoreManager.isExistingUser(DEFAULT_RESERVED_USERNAME);
                if (isReservedUserCreated) break block6;
                try {
                    userStoreManager.addUser(DEFAULT_RESERVED_USERNAME, (Object)this.getSaltString(), new String[]{EVERYONE_ROLE}, new HashMap(), DEFAULT_RESERVED_USERNAME, false);
                }
                catch (UserStoreException ex) {
                    if (ex.getMessage().contains(USERSTORE_USERNALE_VALIDATION_EXCEPTION_CODE)) {
                        log.warn((Object)("Unable to create the reserved user. " + ex.getMessage()));
                        return;
                    }
                    throw new UserStoreException((Throwable)ex);
                }
            }
            catch (UserStoreException e) {
                log.error((Object)"Error occurred while getting the realm configuration, User store properties might not be returned", (Throwable)e);
            }
        }
    }

    int getTenantId() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public void terminatingConfigurationContext(ConfigurationContext configContext) {
    }

    public void completingServerStartup() {
    }

    public void completedServerStartup() {
        this.createReservedUser();
    }

    private String getSaltString() {
        String saltChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)saltChars.length());
            salt.append(saltChars.charAt(index));
        }
        return salt.toString();
    }
}

