/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.api;

import java.util.HashMap;
import java.util.Map;

public class CryptoContext {
    private int tenantId;
    private String tenantDomain;
    private String type;
    private String identifier;
    private String purpose;
    private Map<String, String> properties;

    public CryptoContext(int tenantId, String tenantDomain, String type, String identifier, String purpose, Map<String, String> properties) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.type = type;
        this.identifier = identifier;
        this.purpose = purpose;
        this.properties = properties;
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
    }

    public static CryptoContext buildEmptyContext(int tenantId, String tenantDomain) {
        return new CryptoContext(tenantId, tenantDomain, null, null, null, null);
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public String getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void addProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String toString() {
        return "CryptoContext{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", type='" + this.type + '\'' + ", identifier='" + this.identifier + '\'' + ", purpose='" + this.purpose + '\'' + '}';
    }
}

