/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util.client.api;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementEndpointUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiClient;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Configuration;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Pair;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.Claim;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.UserClaim;

public class UsernameRecoveryApi {
    final String[] localVarAccepts = new String[]{"application/json"};
    final String[] localVarContentTypes = new String[]{"application/json"};
    String basePath = IdentityManagementEndpointUtil.buildEndpointUrl("/api/identity/recovery/v0.9");
    private ApiClient apiClient;

    public UsernameRecoveryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsernameRecoveryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<Claim> claimsGet(String tenantDomain) throws ApiException {
        return this.claimsGet(tenantDomain, true);
    }

    public List<Claim> claimsGet(String tenantDomain, boolean isEndpointTenantAware) throws ApiException {
        Object localVarPostBody = null;
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9", isEndpointTenantAware);
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/claims".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tenant-domain", tenantDomain));
        String localVarAccept = this.apiClient.selectHeaderAccept(this.localVarAccepts);
        String localVarContentType = this.apiClient.selectHeaderContentType(this.localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<Claim>> localVarReturnType = new GenericType<List<Claim>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void recoverUsernamePost(List<UserClaim> claim, String tenantDomain, Boolean notify) throws ApiException {
        this.recoverUsernamePost(claim, tenantDomain, notify, null);
    }

    public void recoverUsernamePost(List<UserClaim> claim, String tenantDomain, Boolean notify, Map<String, String> headers) throws ApiException {
        List<UserClaim> localVarPostBody = claim;
        if (claim == null) {
            throw new ApiException(400, "Missing the required parameter 'claim' when calling recoverUsernamePost");
        }
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9");
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/recover-username/".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(headers)) {
            localVarHeaderParams.putAll(headers);
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tenant-domain", tenantDomain));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "notify", notify));
        String localVarAccept = this.apiClient.selectHeaderAccept(this.localVarAccepts);
        String localVarContentType = this.apiClient.selectHeaderContentType(this.localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<Claim> getClaimsForUsernameRecovery(String tenantDomain, boolean isEndpointTenantAware) throws ApiException {
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9", isEndpointTenantAware);
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/claims".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tenant-domain", tenantDomain));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "isUsernameRecovery", true));
        String localVarAccept = this.apiClient.selectHeaderAccept(this.localVarAccepts);
        String localVarContentType = this.apiClient.selectHeaderContentType(this.localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<Claim>> localVarReturnType = new GenericType<List<Claim>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, null, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

