/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util.client.api;

import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementEndpointUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiClient;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Configuration;
import org.wso2.carbon.identity.mgt.endpoint.util.client.Pair;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.ReCaptchaProperties;

public class ReCaptchaApi {
    private static final String TENANTDOMAIN = "tenant-domain";
    private static final String CAPTCHA_TYPE = "captcha-type";
    private static final String RECOVERY_TYPE = "recovery-type";
    private final String[] localVarAccepts = new String[]{"application/json"};
    private final String[] localVarContentTypes = new String[]{"application/json"};
    private String basePath = IdentityManagementEndpointUtil.buildEndpointUrl("/api/identity/recovery/v0.9");
    private ApiClient apiClient;

    public ReCaptchaApi() {
        this(Configuration.getDefaultApiClient());
    }

    private ReCaptchaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ReCaptchaProperties getReCaptcha(String tenantDomain, boolean isEndpointTenantAware, String captchaType, String recoveryType) throws ApiException {
        if (StringUtils.isBlank((String)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        this.basePath = IdentityManagementEndpointUtil.getBasePath(tenantDomain, "/api/identity/recovery/v0.9", isEndpointTenantAware);
        this.apiClient.setBasePath(this.basePath);
        String localVarPath = "/captcha";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", TENANTDOMAIN, tenantDomain));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", CAPTCHA_TYPE, captchaType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", RECOVERY_TYPE, recoveryType));
        String localVarAccept = this.apiClient.selectHeaderAccept(this.localVarAccepts);
        String localVarContentType = this.apiClient.selectHeaderContentType(this.localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ReCaptchaProperties> localVarReturnType = new GenericType<ReCaptchaProperties>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, null, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

