/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util.client;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementEndpointUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementServiceUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.SelfRegistrationMgtClientException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.User;

public class SelfRegistrationMgtClient {
    private static final String CLIENT = "Client ";
    private static final Log log = LogFactory.getLog(SelfRegistrationMgtClient.class);
    private static final String CONSENT_API_RELATIVE_PATH = "/api/identity/consent-mgt/v1.0";
    private static final String USERNAME_VALIDATE_API_RELATIVE_PATH = "/api/identity/user/v1.0/validate-username";
    private static final String PURPOSE_ID = "purposeId";
    private static final String PURPOSES_ENDPOINT_RELATIVE_PATH = "/consents/purposes";
    private static final String PURPOSES_CATEGORIES_ENDPOINT_RELATIVE_PATH = "/consents/purpose-categories";
    private static final String PURPOSES = "purposes";
    private static final String PURPOSE = "purpose";
    private static final String PII_CATEGORIES = "piiCategories";
    private static final String PURPOSE_CATEGORY = "purposeCategory";
    private static final String PURPOSE_CATEGORY_ID = "purposeCategoryId";
    private static final String DEFAULT = "DEFAULT";
    private static final String USERNAME = "username";
    private static final String PROPERTIES = "properties";

    public String getPurposes(String tenantDomain, String group, String groupType) throws SelfRegistrationMgtClientException {
        String purposesJsonString = "";
        String purposesEndpoint = this.getPurposesEndpoint(tenantDomain);
        purposesEndpoint = purposesEndpoint + "?group=" + group + "&groupType=" + groupType;
        try {
            String purposesResponse = this.executeGet(purposesEndpoint);
            JSONArray purposes = new JSONArray(purposesResponse);
            JSONArray purposesResponseArray = new JSONArray();
            for (int purposeIndex = 0; purposeIndex < purposes.length(); ++purposeIndex) {
                JSONObject purpose = (JSONObject)purposes.get(purposeIndex);
                if (this.isDefaultPurpose(purpose) || !this.hasPIICategories(purpose = this.retrievePurpose(purpose.getInt(PURPOSE_ID), tenantDomain))) continue;
                purposesResponseArray.put((Object)purpose);
            }
            if (purposesResponseArray.length() != 0) {
                JSONObject purposesJson = new JSONObject();
                purposesJson.put(PURPOSES, (Object)purposesResponseArray);
                purposesJsonString = purposesJson.toString();
            }
            return purposesJsonString;
        }
        catch (IOException e) {
            throw new SelfRegistrationMgtClientException("Error while retrieving purposes", e);
        }
    }

    public int getDefaultPurposeId(String tenantDomain) throws SelfRegistrationMgtClientException {
        try {
            String purposesCategoriesResponse = this.executeGet(this.getPurposeCategoriesEndpoint(tenantDomain));
            JSONArray purposesCategories = new JSONArray(purposesCategoriesResponse);
            for (int purpseCatIndex = 0; purpseCatIndex < purposesCategories.length(); ++purpseCatIndex) {
                JSONObject purposeCategory = (JSONObject)purposesCategories.get(purpseCatIndex);
                if (!DEFAULT.equals(purposeCategory.getString(PURPOSE_CATEGORY))) continue;
                return purposeCategory.getInt(PURPOSE_CATEGORY_ID);
            }
        }
        catch (IOException e) {
            throw new SelfRegistrationMgtClientException("Error while retrieving default purpose for tenant: " + tenantDomain, e);
        }
        throw new SelfRegistrationMgtClientException("Couldn't find default purpose for tenant: " + tenantDomain);
    }

    private String getPurposesEndpoint(String tenantDomain) throws SelfRegistrationMgtClientException {
        return this.getEndpoint(tenantDomain, "/api/identity/consent-mgt/v1.0/consents/purposes");
    }

    private String getPurposeCategoriesEndpoint(String tenantDomain) throws SelfRegistrationMgtClientException {
        return this.getEndpoint(tenantDomain, "/api/identity/consent-mgt/v1.0/consents/purpose-categories");
    }

    private String getUserAPIEndpoint(String tenantDomain) throws SelfRegistrationMgtClientException {
        return this.getEndpoint(tenantDomain, USERNAME_VALIDATE_API_RELATIVE_PATH);
    }

    private String getEndpoint(String tenantDomain, String context) throws SelfRegistrationMgtClientException {
        try {
            return IdentityManagementEndpointUtil.getBasePath(tenantDomain, context);
        }
        catch (ApiException e) {
            throw new SelfRegistrationMgtClientException("Error while building url for context: " + context);
        }
    }

    /*
     * Exception decompiling
     */
    private String executeGet(String url) throws SelfRegistrationMgtClientException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Integer checkUsernameValidity(String username) throws SelfRegistrationMgtClientException {
        return this.checkUsernameValidity(username, false);
    }

    @Deprecated
    public Integer checkUsernameValidity(String username, boolean skipSignUpCheck) throws SelfRegistrationMgtClientException {
        User user = new User();
        user.setUsername(username);
        return this.checkUsernameValidity(user, skipSignUpCheck);
    }

    /*
     * Exception decompiling
     */
    public Integer checkUsernameValidity(User user, boolean skipSignUpCheck) throws SelfRegistrationMgtClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setAuthorizationHeader(HttpRequestBase httpMethod) {
        String toEncode = IdentityManagementServiceUtil.getInstance().getAppName() + ":" + String.valueOf(IdentityManagementServiceUtil.getInstance().getAppPassword());
        byte[] encoding = Base64.encodeBase64((byte[])toEncode.getBytes());
        String authHeader = new String(encoding, Charset.defaultCharset());
        httpMethod.addHeader("Authorization", CLIENT + authHeader);
    }

    private JSONObject retrievePurpose(int purposeId, String tenantDomain) throws SelfRegistrationMgtClientException, IOException {
        String purposeResponse = this.executeGet(this.getPurposesEndpoint(tenantDomain) + "/" + purposeId);
        JSONObject purpose = new JSONObject(purposeResponse);
        return purpose;
    }

    private boolean isDefaultPurpose(JSONObject purpose) {
        return DEFAULT.equalsIgnoreCase(purpose.getString(PURPOSE));
    }

    private boolean hasPIICategories(JSONObject purpose) {
        JSONArray piiCategories = (JSONArray)purpose.get(PII_CATEGORIES);
        return piiCategories.length() > 0;
    }
}

