/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.User;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class IdentityManagementServiceUtil {
    private static IdentityManagementServiceUtil instance = new IdentityManagementServiceUtil();
    private JSONProvider jsonProvider = new JSONProvider();
    private List providers = new ArrayList();
    private String accessUsername;
    private String accessPassword;
    private String serviceContextURL;
    private String contextURL;
    private String appName;
    private char[] appPassword;
    private static final String DEFAULT_CALLBACK_HANDLER = "org.wso2.carbon.securevault.DefaultSecretCallbackHandler";
    private static final String SECRET_PROVIDER = "secretProvider";
    private static final Log log = LogFactory.getLog(IdentityManagementServiceUtil.class);

    public static IdentityManagementServiceUtil getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        InputStream inputStream = null;
        this.jsonProvider.setDropRootElement(true);
        this.jsonProvider.setIgnoreNamespaces(true);
        this.jsonProvider.setValidateOutput(true);
        this.jsonProvider.setSupportUnwrapped(true);
        this.providers.add(this.jsonProvider);
        try {
            String serviceContextURL;
            Properties properties = new Properties();
            File currentDirectory = new File(new File(".").getAbsolutePath());
            String configFilePath = currentDirectory.getCanonicalPath() + File.separator + "./repository/conf/identity/RecoveryEndpointConfig.properties";
            File configFile = new File(configFilePath);
            if (configFile.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"RecoveryEndpointConfig.properties file loaded from ./repository/conf/identity/RecoveryEndpointConfig.properties");
                }
                inputStream = new FileInputStream(configFile);
                properties.load(inputStream);
                IdentityManagementServiceUtil.resolveSecrets(properties);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"RecoveryEndpointConfig.properties file loaded from account recovery endpoint webapp");
                }
                inputStream = IdentityManagementServiceUtil.class.getClassLoader().getResourceAsStream("RecoveryEndpointConfig.properties");
                properties.load(inputStream);
            }
            this.accessUsername = properties.getProperty("identity.server.service.access.username");
            this.accessPassword = properties.getProperty("identity.server.service.access.password");
            this.appName = properties.getProperty("app.name");
            this.appPassword = properties.getProperty("app.password").toCharArray();
            this.contextURL = serviceContextURL = properties.getProperty("identity.server.service.contextURL");
            this.serviceContextURL = StringUtils.isBlank((String)serviceContextURL) ? IdentityUtil.getServerURL((String)IdentityUtil.getServicePath(), (boolean)true, (boolean)true) : serviceContextURL;
        }
        catch (IOException e) {
            log.error((Object)"Failed to load service configurations.", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the FileInputStream for file : RecoveryEndpointConfig.properties", (Throwable)e);
                }
            }
        }
    }

    public String getServiceContextURL() {
        return this.serviceContextURL;
    }

    public String getContextURLFromFile() {
        return this.contextURL;
    }

    public void authenticate(ServiceClient client) {
        IdentityManagementServiceUtil.setAutheticationOptions(client, this.accessUsername, this.accessPassword);
    }

    static void setAutheticationOptions(ServiceClient client, String accessUsername, String accessPassword) {
        Options option = client.getOptions();
        HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
        auth.setUsername(accessUsername);
        auth.setPassword(accessPassword);
        auth.setPreemptiveAuthentication(true);
        option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
        option.setManageSession(true);
    }

    public List getJSONProvider() {
        return this.providers;
    }

    private static boolean isSecuredPropertyAvailable(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!StringUtils.startsWith((String)properties.getProperty(key), (String)"secretAlias:")) continue;
            return true;
        }
        return false;
    }

    private static void resolveSecrets(Properties properties) {
        String secretProvider = (String)properties.get(SECRET_PROVIDER);
        if (StringUtils.isBlank((String)secretProvider)) {
            properties.put(SECRET_PROVIDER, DEFAULT_CALLBACK_HANDLER);
        }
        SecretResolver secretResolver = SecretResolverFactory.create((Properties)properties);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (value != null) {
                value = MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
            }
            properties.put(key, value);
        }
    }

    public User getUser(String userName) {
        if (userName == null) {
            return null;
        }
        String userStoreDomain = this.extractDomainFromName(userName);
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        String userNameWithoutTenantDomainAndUserStoreDomain = MultitenantUtils.getTenantAwareUsername((String)UserCoreUtil.removeDomainFromName((String)userName));
        User user = new User();
        user.setUsername(userNameWithoutTenantDomainAndUserStoreDomain);
        user.setRealm(userStoreDomain);
        user.setTenantDomain(tenantDomain);
        return user;
    }

    public User resolveUser(String username, String tenantDomain, boolean isSaaSEnabled) {
        if (username == null) {
            return null;
        }
        String userStoreDomain = this.extractDomainFromName(username);
        User user = new User();
        user.setUsername(MultitenantUtils.getTenantAwareUsername((String)UserCoreUtil.removeDomainFromName((String)username)));
        if (isSaaSEnabled) {
            user.setTenantDomain(MultitenantUtils.getTenantDomain((String)username));
        } else {
            user.setTenantDomain(tenantDomain);
        }
        user.setRealm(userStoreDomain);
        return user;
    }

    public String getAppName() {
        return this.appName;
    }

    public char[] getAppPassword() {
        return this.appPassword;
    }

    private String extractDomainFromName(String nameWithDomain) {
        if (nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) > 0) {
            String domain = nameWithDomain.substring(0, nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR));
            return domain.toUpperCase();
        }
        return null;
    }
}

