/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.mgt.endpoint.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.json.JSONArray;
import org.json.JSONObject;
import org.owasp.encoder.Encode;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.IdentityManagementServiceUtil;
import org.wso2.carbon.identity.mgt.endpoint.util.client.ApiException;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.Claim;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.Error;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.RetryError;
import org.wso2.carbon.identity.mgt.endpoint.util.client.model.User;
import org.wso2.carbon.identity.mgt.stub.beans.VerificationBean;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class IdentityManagementEndpointUtil {
    public static final String PADDING_CHAR = "=";
    public static final String UNDERSCORE = "_";
    public static final String SPLITTING_CHAR = "&";
    public static final String PII_CATEGORIES = "piiCategories";
    public static final String PII_CATEGORY = "piiCategory";
    public static final String PURPOSES = "purposes";
    public static final String MANDATORY = "mandatory";
    public static final String DISPLAY_NAME = "displayName";
    private static final String PROTECTED_TOKENS = "protectedTokens";
    private static final String DEFAULT_CALLBACK_HANDLER = "org.wso2.carbon.securevault.DefaultSecretCallbackHandler";
    private static final String SECRET_PROVIDER = "secretProvider";
    private static final Log log = LogFactory.getLog(IdentityManagementEndpointUtil.class);
    private static final String CODE = "51007";
    private static final String UNEXPECTED_ERROR = "Unexpected Error.";
    private static String accessUsername = null;
    private static String accessPassword = null;

    private IdentityManagementEndpointUtil() {
    }

    public static final String getFullQualifiedUsername(String username, String tenantDomain, String userStoreDomain) {
        String fullQualifiedUsername = username;
        if (StringUtils.isNotBlank((String)userStoreDomain) && !"PRIMARY".equals(userStoreDomain)) {
            fullQualifiedUsername = userStoreDomain + "/" + fullQualifiedUsername;
        }
        if (StringUtils.isNotBlank((String)tenantDomain) && !"carbon.super".equals(tenantDomain)) {
            fullQualifiedUsername = fullQualifiedUsername + "@" + tenantDomain;
        }
        return fullQualifiedUsername;
    }

    public static String getPrintableError(String errorMsgSummary, String optionalErrorMsg, VerificationBean verificationBean) {
        StringBuilder errorMsg = new StringBuilder(errorMsgSummary);
        if (verificationBean != null && StringUtils.isNotBlank((String)verificationBean.getError())) {
            String[] error = verificationBean.getError().split(" ", 2);
            errorMsg.append(" ").append(error[1]);
        } else if (StringUtils.isNotBlank((String)optionalErrorMsg)) {
            errorMsg.append(" ").append(optionalErrorMsg);
        }
        return errorMsg.toString();
    }

    public static final String getUserPortalUrl(String userPortalUrl) {
        if (StringUtils.isNotBlank((String)userPortalUrl)) {
            return userPortalUrl;
        }
        try {
            return ServiceURLBuilder.create().addPath(new String[]{"/myaccount"}).build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw new IdentityRuntimeException("Error while building url for context: /myaccount");
        }
    }

    public static boolean getBooleanValue(Object value) {
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static String getStringValue(Object value) {
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public static int getIntValue(Object value) {
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public static String[] getStringArray(Object value) {
        if (value != null && value instanceof String[]) {
            return (String[])value;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public static <T> T create(String baseAddress, Class<T> cls, List<?> providers, String configLocation, Map<String, String> headers) {
        JAXRSClientFactoryBean bean = IdentityManagementEndpointUtil.getBean(baseAddress, cls, configLocation, headers);
        bean.setProviders(providers);
        return (T)bean.create(cls, new Object[0]);
    }

    private static JAXRSClientFactoryBean getBean(String baseAddress, Class<?> cls, String configLocation, Map<String, String> headers) {
        JAXRSClientFactoryBean bean = IdentityManagementEndpointUtil.getBean(baseAddress, configLocation, headers);
        bean.setServiceClass(cls);
        return bean;
    }

    static JAXRSClientFactoryBean getBean(String baseAddress, String configLocation, Map<String, String> headers) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        if (configLocation != null) {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus(configLocation);
            bean.setBus(bus);
        }
        bean.setAddress(baseAddress);
        if (headers != null && !headers.isEmpty()) {
            bean.setHeaders(headers);
        }
        return bean;
    }

    public static void addReCaptchaHeaders(HttpServletRequest request, Map<String, List<String>> headers) {
        if (headers != null && headers.get("reCaptcha") != null) {
            request.setAttribute("reCaptcha", (Object)Boolean.TRUE.toString());
            request.setAttribute("reCaptchaAPI", (Object)headers.get("reCaptchaAPI").get(0));
            request.setAttribute("reCaptchaKey", (Object)headers.get("reCaptchaKey").get(0));
        }
    }

    public static String buildConsentForResidentIDP(String username, String consent, String jurisdiction, String collectionMethod, String language, String policyURL, String consentType, boolean isPrimaryPurpose, boolean isThirdPartyDisclosure, String termination) {
        if (StringUtils.isEmpty((String)consent)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Empty consent string. Hence returning without building consent from endpoint");
            }
            return consent;
        }
        String piiPrincipalId = IdentityManagementEndpointUtil.getPiiPrincipalID(username);
        JSONObject receipt = new JSONObject(consent);
        receipt.put("jurisdiction", (Object)jurisdiction);
        receipt.put("collectionMethod", (Object)collectionMethod);
        receipt.put("language", (Object)language);
        receipt.put("piiPrincipalId", (Object)piiPrincipalId);
        receipt.put("policyURL", (Object)policyURL);
        IdentityManagementEndpointUtil.buildServices(receipt, consentType, isPrimaryPurpose, isThirdPartyDisclosure, termination);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Built consent from endpoint util : " + consent));
        }
        return receipt.toString();
    }

    private static String getPiiPrincipalID(String username) {
        User user = IdentityManagementServiceUtil.getInstance().getUser(username);
        String piiPrincipalId = StringUtils.isNotBlank((String)user.getRealm()) && !"PRIMARY".equals(user.getRealm()) ? user.getRealm() + "/" + user.getUsername() : user.getUsername();
        return piiPrincipalId;
    }

    private static void buildServices(JSONObject receipt, String consentType, boolean isPrimaryPurpose, boolean isThirdPartyDisclosure, String termination) {
        JSONArray services = (JSONArray)receipt.get("services");
        for (int serviceIndex = 0; serviceIndex < services.length(); ++serviceIndex) {
            IdentityManagementEndpointUtil.buildService((JSONObject)services.get(serviceIndex), consentType, isPrimaryPurpose, isThirdPartyDisclosure, termination);
        }
    }

    private static void buildService(JSONObject service, String consentType, boolean isPrimaryPurpose, boolean isThirdPartyDisclosure, String termination) {
        JSONArray purposes = (JSONArray)service.get(PURPOSES);
        for (int purposeIndex = 0; purposeIndex < purposes.length(); ++purposeIndex) {
            IdentityManagementEndpointUtil.buildPurpose((JSONObject)purposes.get(purposeIndex), consentType, isPrimaryPurpose, isThirdPartyDisclosure, termination);
        }
    }

    private static void buildPurpose(JSONObject purpose, String consentType, boolean isPrimaryPurpose, boolean isThirdPartyDisclosure, String termination) {
        purpose.put("consentType", (Object)consentType);
        purpose.put("primaryPurpose", isPrimaryPurpose);
        purpose.put("thirdPartyDisclosure", isThirdPartyDisclosure);
        purpose.put("termination", (Object)termination);
        JSONArray piiCategories = (JSONArray)purpose.get(PII_CATEGORY);
        for (int categoryIndex = 0; categoryIndex < piiCategories.length(); ++categoryIndex) {
            IdentityManagementEndpointUtil.buildCategory((JSONObject)piiCategories.get(categoryIndex), termination);
        }
    }

    private static void buildCategory(JSONObject piiCategory, String validity) {
        piiCategory.put("validity", (Object)validity);
    }

    public static String i18n(ResourceBundle resourceBundle, String key) {
        try {
            return Encode.forHtml((String)(StringUtils.isNotBlank((String)resourceBundle.getString(key)) ? resourceBundle.getString(key) : key));
        }
        catch (Exception e) {
            return Encode.forHtml((String)key);
        }
    }

    public static String i18nBase64(ResourceBundle resourceBundle, String key) {
        String base64Key = Base64.encode((byte[])key.getBytes(StandardCharsets.UTF_8)).replaceAll(PADDING_CHAR, UNDERSCORE);
        try {
            return Encode.forHtml((String)(StringUtils.isNotBlank((String)resourceBundle.getString(base64Key)) ? resourceBundle.getString(base64Key) : key));
        }
        catch (Exception e) {
            return Encode.forHtml((String)key);
        }
    }

    public static Map<String, Claim> getUniquePIIs(String purposesResponseString) {
        HashMap<String, Claim> claimsMap = new HashMap<String, Claim>();
        JSONObject purposes = new JSONObject(purposesResponseString);
        JSONArray purposesArray = purposes.getJSONArray(PURPOSES);
        for (int i = 0; i < purposesArray.length(); ++i) {
            JSONObject purpose = purposesArray.getJSONObject(i);
            JSONArray piis = (JSONArray)purpose.get(PII_CATEGORIES);
            for (int j = 0; j < piis.length(); ++j) {
                Claim claim;
                JSONObject pii = piis.getJSONObject(j);
                if (claimsMap.get(pii.getString(PII_CATEGORY)) == null) {
                    claim = new Claim();
                    claim.displayName(IdentityManagementEndpointUtil.getStringValue(pii.get(DISPLAY_NAME)));
                    claim.setUri(IdentityManagementEndpointUtil.getStringValue(pii.get(PII_CATEGORY)));
                    claim.required(pii.getBoolean(MANDATORY));
                    claimsMap.put(IdentityManagementEndpointUtil.getStringValue(pii.get(PII_CATEGORY)), claim);
                    continue;
                }
                claim = (Claim)claimsMap.get(pii.getString(PII_CATEGORY));
                if (!pii.getBoolean(MANDATORY)) continue;
                claim.required(true);
            }
        }
        return claimsMap;
    }

    public static Map<String, Claim> fillPiisWithClaimInfo(Map<String, Claim> piis, List<Claim> defaultClaims) {
        if (piis != null) {
            for (Claim defaultClaim : defaultClaims) {
                if (defaultClaim == null || defaultClaim.getUri() == null || piis.get(defaultClaim.getUri()) == null) continue;
                piis.get(defaultClaim.getUri()).setValidationRegex(defaultClaim.getValidationRegex());
                piis.get(defaultClaim.getUri()).setReadOnly(defaultClaim.getReadOnly());
            }
        } else {
            piis = new HashMap<String, Claim>();
            for (Claim defaultClaim : defaultClaims) {
                if (defaultClaim == null || defaultClaim.getUri() == null) continue;
                piis.put(defaultClaim.getUri(), defaultClaim);
            }
        }
        return piis;
    }

    public static String encodeURL(String callbackUrl) throws MalformedURLException {
        URL url = new URL(callbackUrl);
        StringBuilder encodedCallbackUrl = new StringBuilder(new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), null).toString());
        Map<String, String> encodedQueryMap = IdentityManagementEndpointUtil.getEncodedQueryParamMap(url.getQuery());
        if (MapUtils.isNotEmpty(encodedQueryMap)) {
            encodedCallbackUrl.append("?");
            encodedCallbackUrl.append(encodedQueryMap.keySet().stream().map(key -> key + PADDING_CHAR + (String)encodedQueryMap.get(key)).collect(Collectors.joining(SPLITTING_CHAR)));
        }
        return encodedCallbackUrl.toString();
    }

    @Deprecated
    public static String getURLEncodedCallback(String callbackUrl) throws URISyntaxException {
        if (StringUtils.isBlank((String)callbackUrl)) {
            return callbackUrl;
        }
        callbackUrl = callbackUrl.trim().replace(" ", "%20");
        URI uri = new URI(callbackUrl);
        StringBuilder encodedCallbackUrl = new StringBuilder(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString());
        Map<String, String> encodedQueryMap = IdentityManagementEndpointUtil.getEncodedQueryParamMap(uri.getQuery());
        if (MapUtils.isNotEmpty(encodedQueryMap)) {
            encodedCallbackUrl.append("?");
            encodedCallbackUrl.append(encodedQueryMap.keySet().stream().map(key -> key + PADDING_CHAR + (String)encodedQueryMap.get(key)).collect(Collectors.joining(SPLITTING_CHAR)));
        }
        return encodedCallbackUrl.toString();
    }

    public static Map<String, String> getEncodedQueryParamMap(String queryParams) {
        Map<String, String> encodedQueryMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)queryParams)) {
            encodedQueryMap = Arrays.stream(queryParams.split(SPLITTING_CHAR)).map(entry -> entry.split(PADDING_CHAR)).collect(Collectors.toMap(entry -> Encode.forUriComponent((String)entry[0]), entry -> Encode.forUriComponent((String)entry[1])));
        }
        return encodedQueryMap;
    }

    @Deprecated
    public static String buildEndpointUrl(String path) {
        String serviceContextURL = IdentityManagementServiceUtil.getInstance().getServiceContextURL();
        String endpointUrl = IdentityManagementEndpointUtil.replaceLastOccurrence(serviceContextURL, "/services", "");
        if (path.startsWith("/")) {
            return endpointUrl + path;
        }
        return endpointUrl + "/" + path;
    }

    private static String replaceLastOccurrence(String base, String toReplace, String replaceWith) {
        int lastIndex = base.lastIndexOf(toReplace);
        if (lastIndex == -1) {
            return base;
        }
        String begin = base.substring(0, lastIndex);
        String end = base.substring(lastIndex + toReplace.length());
        return begin + replaceWith + end;
    }

    public static void addErrorInformation(HttpServletRequest request, Exception e) {
        Error error = IdentityManagementEndpointUtil.buildError(e);
        IdentityManagementEndpointUtil.addErrorInformation(request, error);
    }

    public static void addErrorInformation(HttpServletRequest request, Error errorD) {
        request.setAttribute("error", (Object)true);
        if (errorD != null) {
            request.setAttribute("errorMsg", (Object)errorD.getDescription());
            request.setAttribute("errorCode", (Object)errorD.getCode());
        }
    }

    public static Error buildError(Exception e) {
        try {
            return (Error)new Gson().fromJson(e.getMessage(), Error.class);
        }
        catch (JsonSyntaxException ex) {
            log.error((Object)"Exception while retrieving error details from original exception. Original exception:", (Throwable)e);
            return IdentityManagementEndpointUtil.buildUnexpectedError();
        }
    }

    private static Error buildUnexpectedError() {
        Error error = new Error();
        error.setCode(CODE);
        error.setMessage(UNEXPECTED_ERROR);
        error.setDescription(UNEXPECTED_ERROR);
        return error;
    }

    private static RetryError buildUnexpectedRetryError() {
        RetryError error = new RetryError();
        error.setCode(CODE);
        error.setMessage(UNEXPECTED_ERROR);
        error.setDescription(UNEXPECTED_ERROR);
        return error;
    }

    public static RetryError buildRetryError(Exception e) {
        try {
            return (RetryError)new Gson().fromJson(e.getMessage(), RetryError.class);
        }
        catch (JsonSyntaxException ex) {
            log.error((Object)"Exception while retrieving error details from original exception. Original exception:", (Throwable)e);
            return IdentityManagementEndpointUtil.buildUnexpectedRetryError();
        }
    }

    public static void authenticate(ServiceClient client) throws Exception {
        if (accessPassword == null || accessUsername == null) {
            IdentityManagementEndpointUtil.loadCredentials();
        }
        if (accessUsername == null || accessPassword == null) {
            throw new Exception("Authentication username or password not set");
        }
        IdentityManagementEndpointUtil.setOptions(client, accessUsername, accessPassword);
    }

    private static void loadCredentials() throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = IdentityManagementServiceUtil.class.getClassLoader().getResourceAsStream("RecoveryEndpointConfig.properties");){
            properties.load(inputStream);
            IdentityManagementEndpointUtil.resolveSecrets(properties);
        }
        accessUsername = properties.getProperty("identity.server.service.access.username");
        accessPassword = properties.getProperty("identity.server.service.access.password");
    }

    public static void setOptions(ServiceClient client, String accessUsername, String accessPassword) {
        IdentityManagementServiceUtil.setAutheticationOptions(client, accessUsername, accessPassword);
    }

    public static String getBasePath(String tenantDomain, String context) throws ApiException {
        return IdentityManagementEndpointUtil.getBasePath(tenantDomain, context, true);
    }

    public static String getBasePath(String tenantDomain, String context, boolean isEndpointTenantAware) throws ApiException {
        String basePath;
        String serverUrl = IdentityManagementServiceUtil.getInstance().getContextURLFromFile();
        try {
            if (StringUtils.isBlank((String)serverUrl)) {
                if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                    basePath = ServiceURLBuilder.create().addPath(new String[]{context}).build().getAbsoluteInternalURL();
                } else {
                    serverUrl = ServiceURLBuilder.create().build().getAbsoluteInternalURL();
                    basePath = StringUtils.isNotBlank((String)tenantDomain) && !"carbon.super".equalsIgnoreCase(tenantDomain) && isEndpointTenantAware ? serverUrl + "/t/" + tenantDomain + context : serverUrl + context;
                }
            } else {
                basePath = serverUrl + context;
            }
        }
        catch (URLBuilderException e) {
            throw new ApiException("Error while building url for context: " + context);
        }
        return basePath;
    }

    private static boolean isSecuredPropertyAvailable(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!PROTECTED_TOKENS.equals(key) || !StringUtils.isNotBlank((String)properties.getProperty(key))) continue;
            return true;
        }
        return false;
    }

    private static void resolveSecrets(Properties properties) {
        SecretResolver secretResolver;
        String secretProvider = (String)properties.get(SECRET_PROVIDER);
        if (StringUtils.isBlank((String)secretProvider)) {
            properties.put(SECRET_PROVIDER, DEFAULT_CALLBACK_HANDLER);
        }
        if ((secretResolver = SecretResolverFactory.create((Properties)properties)) != null && secretResolver.isInitialized()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (value != null) {
                    value = MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
                }
                properties.put(key, value);
            }
        }
        if (IdentityManagementEndpointUtil.isSecuredPropertyAvailable(properties)) {
            SecretResolver resolver = SecretResolverFactory.create((Properties)properties, (String)"");
            String protectedTokens = (String)properties.get(PROTECTED_TOKENS);
            StringTokenizer st = new StringTokenizer(protectedTokens, ",");
            while (st.hasMoreElements()) {
                String element = st.nextElement().toString().trim();
                if (resolver.isTokenProtected(element)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resolving and replacing secret for " + element));
                    }
                    properties.put(element, resolver.resolve(element));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No encryption done for value with key :" + element));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Secure vault encryption ignored since no protected tokens available.");
        }
    }

    public static String getQueryParameter(String url, String queryParameter) throws URISyntaxException {
        String queryParams = new URI(url).getQuery();
        Map<Object, Object> queryParamMap = new HashMap();
        if (StringUtils.isNotBlank((String)queryParams)) {
            queryParamMap = Arrays.stream(queryParams.split(SPLITTING_CHAR)).map(entry -> entry.split(PADDING_CHAR)).collect(Collectors.toMap(entry -> entry[0], entry -> entry[1]));
        }
        return (String)queryParamMap.get(queryParameter);
    }
}

