/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.core.util.KeyStoreBean;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.CarbonUtils;

public class KeyStoreManager {
    private KeyStore primaryKeyStore = null;
    private KeyStore registryKeyStore = null;
    private KeyStore internalKeyStore = null;
    private static ConcurrentHashMap<String, KeyStoreManager> mtKeyStoreManagers = new ConcurrentHashMap();
    private static Log log = LogFactory.getLog(KeyStoreManager.class);
    private Registry registry = null;
    private ConcurrentHashMap<String, KeyStoreBean> loadedKeyStores = null;
    private int tenantId = -1234;
    private ServerConfigurationService serverConfigService;
    private RegistryService registryService;

    private KeyStoreManager(int tenantId, ServerConfigurationService serverConfigService, RegistryService registryService) {
        this.serverConfigService = serverConfigService;
        this.registryService = registryService;
        this.loadedKeyStores = new ConcurrentHashMap();
        this.tenantId = tenantId;
        try {
            this.registry = registryService.getGovernanceSystemRegistry(tenantId);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            String message = "Error when retrieving the system governance registry";
            log.error((Object)message, (Throwable)e);
            throw new SecurityException(message, e);
        }
    }

    public ServerConfigurationService getServerConfigService() {
        return this.serverConfigService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public static KeyStoreManager getInstance(int tenantId) {
        return KeyStoreManager.getInstance(tenantId, CarbonCoreDataHolder.getInstance().getServerConfigurationService(), CryptoUtil.lookupRegistryService());
    }

    public static KeyStoreManager getInstance(int tenantId, ServerConfigurationService serverConfigService, RegistryService registryService) {
        CarbonUtils.checkSecurity();
        String tenantIdStr = Integer.toString(tenantId);
        if (!mtKeyStoreManagers.containsKey(tenantIdStr)) {
            mtKeyStoreManagers.put(tenantIdStr, new KeyStoreManager(tenantId, serverConfigService, registryService));
        }
        return mtKeyStoreManagers.get(tenantIdStr);
    }

    public KeyStore getKeyStore(String keyStoreName) throws Exception {
        if (KeyStoreUtil.isPrimaryStore(keyStoreName)) {
            return this.getPrimaryKeyStore();
        }
        if (this.isCachedKeyStoreValid(keyStoreName)) {
            return this.loadedKeyStores.get(keyStoreName).getKeyStore();
        }
        String path = "/repository/security/key-stores/" + keyStoreName;
        if (this.registry.resourceExists(path)) {
            org.wso2.carbon.registry.api.Resource resource = this.registry.get(path);
            byte[] bytes = (byte[])resource.getContent();
            KeyStore keyStore = KeyStore.getInstance(resource.getProperty("type"));
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            String encryptedPassword = resource.getProperty("password");
            String password = new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            keyStore.load(stream, password.toCharArray());
            KeyStoreBean keyStoreBean = new KeyStoreBean(keyStore, resource.getLastModified());
            resource.discard();
            if (this.loadedKeyStores.containsKey(keyStoreName)) {
                this.loadedKeyStores.replace(keyStoreName, keyStoreBean);
            } else {
                this.loadedKeyStores.put(keyStoreName, keyStoreBean);
            }
            return keyStore;
        }
        throw new SecurityException("Key Store with a name : " + keyStoreName + " does not exist.");
    }

    public Key getPrivateKey(String keyStoreName, String alias) {
        try {
            if (KeyStoreUtil.isPrimaryStore(keyStoreName)) {
                return this.getDefaultPrivateKey();
            }
            String path = "/repository/security/key-stores/" + keyStoreName;
            if (!this.registry.resourceExists(path)) {
                throw new SecurityException("Given Key store is not available in registry : " + keyStoreName);
            }
            org.wso2.carbon.registry.api.Resource resource = this.registry.get(path);
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            String encryptedPassword = resource.getProperty("privatekeyPass");
            String privateKeyPasswd = new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
            if (this.isCachedKeyStoreValid(keyStoreName)) {
                KeyStore keyStore = this.loadedKeyStores.get(keyStoreName).getKeyStore();
                return keyStore.getKey(alias, privateKeyPasswd.toCharArray());
            }
            byte[] bytes = (byte[])resource.getContent();
            String keyStorePassword = new String(cryptoUtil.base64DecodeAndDecrypt(resource.getProperty("password")));
            KeyStore keyStore = KeyStore.getInstance(resource.getProperty("type"));
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            keyStore.load(stream, keyStorePassword.toCharArray());
            KeyStoreBean keyStoreBean = new KeyStoreBean(keyStore, resource.getLastModified());
            this.updateKeyStoreCache(keyStoreName, keyStoreBean);
            return keyStore.getKey(alias, privateKeyPasswd.toCharArray());
        }
        catch (Exception e) {
            log.error((Object)("Error loading the private key from the key store : " + keyStoreName));
            throw new SecurityException("Error loading the private key from the key store : " + keyStoreName, e);
        }
    }

    public String getPassword(Resource resource) throws Exception {
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        String encryptedPassword = resource.getProperty("privatekeyPass");
        return new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
    }

    public String getKeyStorePassword(String keyStoreName) throws Exception {
        String path = "/repository/security/key-stores/" + keyStoreName;
        if (this.registry.resourceExists(path)) {
            org.wso2.carbon.registry.api.Resource resource = this.registry.get(path);
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            String encryptedPassword = resource.getProperty("password");
            if (encryptedPassword != null) {
                return new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
            }
            throw new SecurityException("Key Store Password of " + keyStoreName + " does not exist.");
        }
        throw new SecurityException("Key Store with a name : " + keyStoreName + " does not exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeyStore(String name, KeyStore keyStore) throws Exception {
        ServerConfigurationService config = this.getServerConfigService();
        if (KeyStoreUtil.isPrimaryStore(name)) {
            String file = new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath();
            try (FileOutputStream out = null;){
                out = new FileOutputStream(file);
                String password = config.getFirstProperty("Security.KeyStore.Password");
                keyStore.store(out, password.toCharArray());
            }
            return;
        }
        String path = "/repository/security/key-stores/" + name;
        org.wso2.carbon.registry.api.Resource resource = this.registry.get(path);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        String encryptedPassword = resource.getProperty("password");
        String password = new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
        keyStore.store(outputStream, password.toCharArray());
        outputStream.flush();
        outputStream.close();
        resource.setContent((Object)outputStream.toByteArray());
        this.registry.put(path, resource);
        resource.discard();
        this.updateKeyStoreCache(name, new KeyStoreBean(keyStore, new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getPrimaryKeyStore() throws Exception {
        if (this.tenantId == -1234) {
            if (this.primaryKeyStore == null) {
                ServerConfigurationService config = this.getServerConfigService();
                String file = new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath();
                KeyStore store = KeyStore.getInstance(config.getFirstProperty("Security.KeyStore.Type"));
                String password = config.getFirstProperty("Security.KeyStore.Password");
                try (FileInputStream in = null;){
                    in = new FileInputStream(file);
                    store.load(in, password.toCharArray());
                    this.primaryKeyStore = store;
                }
            }
            return this.primaryKeyStore;
        }
        throw new CarbonException("Permission denied for accessing primary key store. The primary key store is available only for the super tenant.");
    }

    public KeyStore getInternalKeyStore() throws Exception {
        if (this.tenantId == -1234) {
            if (this.internalKeyStore == null) {
                ServerConfigurationService config = this.getServerConfigService();
                if (config.getFirstProperty("Security.InternalKeyStore.Location") == null) {
                    return null;
                }
                String file = new File(config.getFirstProperty("Security.InternalKeyStore.Location")).getAbsolutePath();
                KeyStore store = KeyStore.getInstance(config.getFirstProperty("Security.InternalKeyStore.Type"));
                String password = config.getFirstProperty("Security.InternalKeyStore.Password");
                try (FileInputStream in = new FileInputStream(file);){
                    store.load(in, password.toCharArray());
                    this.internalKeyStore = store;
                }
            }
            return this.internalKeyStore;
        }
        throw new CarbonException("Permission denied for accessing internal key store. The internal key store is available only for the super tenant.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public KeyStore getRegistryKeyStore() throws Exception {
        if (this.tenantId == -1234) {
            if (this.registryKeyStore == null) {
                ServerConfigurationService config = this.getServerConfigService();
                String file = new File(config.getFirstProperty("Security.RegistryKeyStore.Location")).getAbsolutePath();
                KeyStore store = KeyStore.getInstance(config.getFirstProperty("Security.RegistryKeyStore.Type"));
                String password = config.getFirstProperty("Security.RegistryKeyStore.Password");
                try (FileInputStream in = null;){
                    in = new FileInputStream(file);
                    store.load(in, password.toCharArray());
                    this.registryKeyStore = store;
                }
            }
            return this.registryKeyStore;
        }
        throw new CarbonException("Permission denied for accessing registry key store. The registry key store is available only for the super tenant.");
    }

    public PrivateKey getDefaultPrivateKey() throws Exception {
        if (this.tenantId == -1234) {
            ServerConfigurationService config = this.getServerConfigService();
            String password = config.getFirstProperty("Security.KeyStore.Password");
            String alias = config.getFirstProperty("Security.KeyStore.KeyAlias");
            return (PrivateKey)this.primaryKeyStore.getKey(alias, password.toCharArray());
        }
        throw new CarbonException("Permission denied for accessing primary key store. The primary key store is available only for the super tenant.");
    }

    public PublicKey getDefaultPublicKey() throws Exception {
        if (this.tenantId == -1234) {
            ServerConfigurationService config = this.getServerConfigService();
            String alias = config.getFirstProperty("Security.KeyStore.KeyAlias");
            return this.primaryKeyStore.getCertificate(alias).getPublicKey();
        }
        throw new CarbonException("Permission denied for accessing primary key store. The primary key store is available only for the super tenant.");
    }

    public String getPrimaryPrivateKeyPasssword() throws CarbonException {
        if (this.tenantId == -1234) {
            ServerConfigurationService config = this.getServerConfigService();
            return config.getFirstProperty("Security.KeyStore.Password");
        }
        throw new CarbonException("Permission denied for accessing primary key store. The primary key store is available only for the super tenant.");
    }

    public X509Certificate getDefaultPrimaryCertificate() throws Exception {
        if (this.tenantId == -1234) {
            ServerConfigurationService config = this.getServerConfigService();
            String alias = config.getFirstProperty("Security.KeyStore.KeyAlias");
            return (X509Certificate)this.getPrimaryKeyStore().getCertificate(alias);
        }
        throw new CarbonException("Permission denied for accessing primary key store. The primary key store is available only for the super tenant.");
    }

    private boolean isCachedKeyStoreValid(String keyStoreName) {
        String path = "/repository/security/key-stores/" + keyStoreName;
        boolean cachedKeyStoreValid = false;
        try {
            if (this.loadedKeyStores.containsKey(keyStoreName)) {
                org.wso2.carbon.registry.api.Resource metaDataResource = this.registry.get(path);
                KeyStoreBean keyStoreBean = this.loadedKeyStores.get(keyStoreName);
                if (keyStoreBean.getLastModifiedDate().equals(metaDataResource.getLastModified())) {
                    cachedKeyStoreValid = true;
                }
            }
        }
        catch (RegistryException e) {
            String errorMsg = "Error reading key store meta data from registry.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SecurityException(errorMsg, e);
        }
        return cachedKeyStoreValid;
    }

    private void updateKeyStoreCache(String keyStoreName, KeyStoreBean keyStoreBean) {
        if (this.loadedKeyStores.containsKey(keyStoreName)) {
            this.loadedKeyStores.replace(keyStoreName, keyStoreBean);
        } else {
            this.loadedKeyStores.put(keyStoreName, keyStoreBean);
        }
    }

    public KeyStore loadKeyStoreFromFileSystem(String keyStorePath, String password, String type) {
        CarbonUtils.checkSecurity();
        String absolutePath = new File(keyStorePath).getAbsolutePath();
        FileInputStream inputStream = null;
        try {
            KeyStore store = KeyStore.getInstance(type);
            inputStream = new FileInputStream(absolutePath);
            store.load(inputStream, password.toCharArray());
            KeyStore keyStore = store;
            return keyStore;
        }
        catch (Exception e) {
            String errorMsg = "Error loading the key store from the given location.";
            log.error((Object)errorMsg);
            throw new SecurityException(errorMsg, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Error when closing the input stream.", (Throwable)e);
            }
        }
    }
}

