/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.util.CipherHolder;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.crypto.api.CipherMetaDataHolder;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.registry.core.service.RegistryService;

public class CryptoUtil {
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";
    private static Log log = LogFactory.getLog(CryptoUtil.class);
    private ServerConfigurationService serverConfigService;
    private RegistryService registryService;
    private Gson gson = new Gson();
    private static CryptoUtil instance = null;
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String DEFAULT_CRYPTO_ALGORITHM = "RSA";
    private static final String CRYPTO_API_PROVIDER_BC = "BC";

    public static CryptoUtil getDefaultCryptoUtil() {
        return CryptoUtil.getDefaultCryptoUtil(CarbonCoreDataHolder.getInstance().getServerConfigurationService(), CryptoUtil.lookupRegistryService());
    }

    public static RegistryService lookupRegistryService() {
        try {
            return CarbonCoreDataHolder.getInstance().getRegistryService();
        }
        catch (Exception e) {
            log.error((Object)("Error in getting RegistryService from CarbonCoreDataHolder: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static synchronized CryptoUtil getDefaultCryptoUtil(ServerConfigurationService serverConfigService, RegistryService registryService) {
        if (instance == null) {
            instance = new CryptoUtil(serverConfigService, registryService);
        }
        return instance;
    }

    private CryptoUtil(ServerConfigurationService serverConfigService, RegistryService registryService) {
        this.serverConfigService = serverConfigService;
        this.registryService = registryService;
    }

    public ServerConfigurationService getServerConfigService() {
        return this.serverConfigService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public byte[] encrypt(byte[] plainTextBytes, String cipherTransformation, boolean returnSelfContainedCipherText) throws CryptoException {
        byte[] encryptedKey;
        if (plainTextBytes == null) {
            throw new CryptoException("Plaintext can't be null.");
        }
        try {
            CryptoService cryptoService = CarbonCoreDataHolder.getInstance().getCryptoService();
            if (cryptoService == null) {
                throw new CryptoException("A crypto service implementation has not been registered.");
            }
            String algorithm = null;
            if (!StringUtils.isBlank((String)cipherTransformation)) {
                algorithm = cipherTransformation;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Cipher transformation is enabled. Crypto algorithm: '%s'", algorithm));
                }
            }
            encryptedKey = cryptoService.encrypt(plainTextBytes, algorithm, CRYPTO_API_PROVIDER_BC, returnSelfContainedCipherText);
        }
        catch (Exception e) {
            throw new CryptoException("An error occurred while encrypting data.", e);
        }
        return encryptedKey;
    }

    public byte[] encrypt(byte[] plainTextBytes) throws CryptoException {
        return this.encrypt(plainTextBytes, System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY), true);
    }

    public byte[] encrypt(byte[] plainTextBytes, String algorithm, boolean returnSelfContainedCipherText, String internalCryptoProviderType) throws CryptoException {
        byte[] encryptedKey;
        this.failIfEncryptDecryptInputsAreInvalid(plainTextBytes, algorithm, internalCryptoProviderType);
        try {
            CryptoService cryptoService = CarbonCoreDataHolder.getInstance().getCryptoService();
            if (cryptoService == null) {
                throw new CryptoException("A crypto service implementation has not been registered.");
            }
            if (plainTextBytes.length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Plaintext is empty. An empty array will be used as the ciphertext bytes.");
                }
                encryptedKey = "".getBytes();
            } else {
                if (log.isDebugEnabled()) {
                    if (returnSelfContainedCipherText) {
                        log.debug((Object)String.format("Encrypting data in self contained format, with algorithm: '%s' and internal crypto provider: '%s'", algorithm, internalCryptoProviderType));
                    } else {
                        log.debug((Object)String.format("Encrypting data with algorithm: '%s' and internal crypto provider: '%s'", algorithm, internalCryptoProviderType));
                    }
                }
                encryptedKey = cryptoService.encrypt(plainTextBytes, algorithm, CRYPTO_API_PROVIDER_BC, returnSelfContainedCipherText, internalCryptoProviderType);
            }
        }
        catch (org.wso2.carbon.crypto.api.CryptoException e) {
            throw new CryptoException("An error occurred while encrypting data.", e);
        }
        return encryptedKey;
    }

    public String encryptAndBase64Encode(byte[] plainText, String transformation, boolean returnSelfContainedCipherText) throws CryptoException {
        return Base64.encode((byte[])this.encrypt(plainText, transformation, returnSelfContainedCipherText));
    }

    public String encryptAndBase64Encode(byte[] plainText) throws CryptoException {
        return Base64.encode((byte[])this.encrypt(plainText));
    }

    public String encryptAndBase64Encode(byte[] plainText, String algorithm, boolean returnSelfContainedCipherText, String internalCryptoProviderType) throws CryptoException {
        return Base64.encode((byte[])this.encrypt(plainText, algorithm, returnSelfContainedCipherText, internalCryptoProviderType));
    }

    public byte[] decrypt(byte[] cipherTextBytes) throws CryptoException {
        if (cipherTextBytes == null) {
            throw new CryptoException("Ciphertext can't be null.");
        }
        try {
            byte[] decryptedValue;
            CryptoService cryptoService = CarbonCoreDataHolder.getInstance().getCryptoService();
            if (cryptoService == null) {
                throw new CryptoException("A crypto service implementation has not been registered.");
            }
            String algorithm = null;
            String cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
            if (cipherTransformation != null) {
                CipherMetaDataHolder cipherMetaDataHolder = this.cipherTextToCipherMetaDataHolder(cipherTextBytes);
                if (cipherMetaDataHolder != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cipher transformation for decryption : " + cipherMetaDataHolder.getTransformation()));
                    }
                    algorithm = cipherMetaDataHolder.getTransformation();
                    cipherTextBytes = cipherMetaDataHolder.getCipherBase64Decoded();
                } else {
                    algorithm = cipherTransformation;
                }
            }
            if (cipherTextBytes.length == 0) {
                decryptedValue = "".getBytes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ciphertext is empty. An empty array will be used as the plaintext bytes.");
                }
            } else {
                decryptedValue = cryptoService.decrypt(cipherTextBytes, algorithm, CRYPTO_API_PROVIDER_BC);
            }
            return decryptedValue;
        }
        catch (Exception e) {
            throw new CryptoException("An error occurred while decrypting data.", e);
        }
    }

    public byte[] decrypt(byte[] cipherTextBytes, String cipherTransformation) throws CryptoException {
        if (cipherTextBytes == null) {
            throw new CryptoException("Ciphertext can't be null.");
        }
        try {
            byte[] decryptedValue;
            CryptoService cryptoService = CarbonCoreDataHolder.getInstance().getCryptoService();
            if (cryptoService == null) {
                throw new CryptoException("A crypto service implementation has not been registered.");
            }
            String algorithm = null;
            if (cipherTransformation != null) {
                algorithm = cipherTransformation;
            }
            if (cipherTextBytes.length == 0) {
                decryptedValue = "".getBytes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ciphertext is empty. An empty array will be used as the plaintext bytes.");
                }
            } else {
                decryptedValue = cryptoService.decrypt(cipherTextBytes, algorithm, CRYPTO_API_PROVIDER_BC);
            }
            return decryptedValue;
        }
        catch (Exception e) {
            throw new CryptoException("An error occurred while decrypting data.", e);
        }
    }

    public byte[] decrypt(byte[] cipherTextBytes, String algorithm, String internalCryptoProviderType) throws CryptoException {
        this.failIfEncryptDecryptInputsAreInvalid(cipherTextBytes, algorithm, internalCryptoProviderType);
        try {
            byte[] decryptedValue;
            CryptoService cryptoService = CarbonCoreDataHolder.getInstance().getCryptoService();
            if (cryptoService == null) {
                throw new CryptoException("A crypto service implementation has not been registered.");
            }
            CipherMetaDataHolder cipherMetaDataHolder = this.cipherTextToCipherMetaDataHolder(cipherTextBytes);
            if (cipherMetaDataHolder != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Cipher text is in self contained format. Retrieve the actual cipher from the self contained cipher text.", new Object[0]));
                }
                cipherTextBytes = cipherMetaDataHolder.getCipherBase64Decoded();
                algorithm = cipherMetaDataHolder.getTransformation();
            }
            if (cipherTextBytes.length == 0) {
                decryptedValue = "".getBytes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ciphertext is empty. An empty array will be used as the plaintext bytes.");
                }
            } else {
                decryptedValue = cryptoService.decrypt(cipherTextBytes, algorithm, CRYPTO_API_PROVIDER_BC, internalCryptoProviderType);
            }
            return decryptedValue;
        }
        catch (org.wso2.carbon.crypto.api.CryptoException e) {
            throw new CryptoException("An error occurred while decrypting data.", e);
        }
    }

    public byte[] base64DecodeAndDecrypt(String base64CipherText) throws CryptoException {
        return this.decrypt(Base64.decode((String)base64CipherText));
    }

    public byte[] base64DecodeAndDecrypt(String base64CipherText, String transformation) throws CryptoException {
        return this.decrypt(Base64.decode((String)base64CipherText), transformation);
    }

    public byte[] base64DecodeAndDecrypt(String base64CipherText, String transformation, String internalCryptoProviderType) throws CryptoException {
        return this.decrypt(Base64.decode((String)base64CipherText), transformation, internalCryptoProviderType);
    }

    public boolean isSelfContainedCipherText(byte[] cipherBytes) {
        return this.cipherTextToCipherHolder(cipherBytes) != null;
    }

    public boolean base64DecodeAndIsSelfContainedCipherText(String base64CipherText) throws CryptoException {
        return this.isSelfContainedCipherText(Base64.decode((String)base64CipherText));
    }

    public byte[] extractOriginalCipher(byte[] cipher) {
        CipherHolder cipherHolder = this.cipherTextToCipherHolder(cipher);
        if (cipherHolder != null) {
            return cipherHolder.getCipherBase64Decoded();
        }
        return cipher;
    }

    @Deprecated
    public byte[] createSelfContainedCiphertext(byte[] originalCipher, String transformation, Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        CipherHolder cipherHolder = new CipherHolder();
        cipherHolder.setCipherText(Base64.encode((byte[])originalCipher));
        cipherHolder.setTransformation(transformation);
        cipherHolder.setThumbPrint(this.calculateThumbprint(certificate, "SHA-1"), "SHA-1");
        String cipherWithMetadataStr = this.gson.toJson((Object)cipherHolder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cipher with meta data : " + cipherWithMetadataStr));
        }
        return cipherWithMetadataStr.getBytes(Charset.defaultCharset());
    }

    @Deprecated
    public CipherHolder cipherTextToCipherHolder(byte[] cipherText) {
        String cipherStr = new String(cipherText, Charset.defaultCharset());
        try {
            return (CipherHolder)this.gson.fromJson(cipherStr, CipherHolder.class);
        }
        catch (JsonSyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Deserialization failed since cipher string is not representing cipher with metadata");
            }
            return null;
        }
    }

    public CipherMetaDataHolder cipherTextToCipherMetaDataHolder(byte[] cipherText) {
        String cipherStr = new String(cipherText, Charset.defaultCharset());
        try {
            return (CipherMetaDataHolder)this.gson.fromJson(cipherStr, CipherMetaDataHolder.class);
        }
        catch (JsonSyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Deserialization failed since cipher string is not representing cipher with metadata");
            }
            return null;
        }
    }

    private String calculateThumbprint(Certificate certificate, String digest) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(digest);
        messageDigest.update(certificate.getEncoded());
        byte[] digestByteArray = messageDigest.digest();
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < digestByteArray.length; ++i) {
            int leftNibble = (digestByteArray[i] & 0xF0) >> 4;
            int rightNibble = digestByteArray[i] & 0xF;
            strBuffer.append(HEX_CHARACTERS[leftNibble]).append(HEX_CHARACTERS[rightNibble]);
        }
        return strBuffer.toString();
    }

    private void failIfEncryptDecryptInputsAreInvalid(byte[] data, String algorithm, String internalCryptoProviderType) throws CryptoException {
        if (data == null) {
            throw new CryptoException("Plaintext can't be null.");
        }
        if (StringUtils.isBlank((String)algorithm)) {
            throw new CryptoException("Encryption algorithm can't be null.");
        }
        if (StringUtils.isBlank((String)internalCryptoProviderType)) {
            throw new CryptoException("Internal crypto provider can't be null.");
        }
    }
}

