/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.ws.commons.schema.XmlSchema;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.util.RequestProcessorUtil;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public final class XsdUtil {
    private XsdUtil() {
    }

    public static void printXsd(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configCtx, String serviceName, AxisService axisService) throws IOException {
        XmlSchema schema;
        if (GhostDeployerUtils.isGhostService((AxisService)axisService)) {
            axisService = GhostDeployerUtils.deployActualService((AxisConfiguration)configCtx.getAxisConfiguration(), (AxisService)axisService);
        }
        if (!RequestProcessorUtil.canExposeServiceMetadata(axisService)) {
            response.setError(403, "Access to service metadata for service: " + serviceName + " has been forbidden");
            return;
        }
        OutputStream outputStream = response.getOutputStream();
        String contextRoot = request.getContextPath();
        if (axisService == null) {
            response.addHeader("Content-Type", "text/html");
            response.setError(404);
            outputStream.write(("<h4>Service " + serviceName + " is not found. Cannot display Schema.</h4>").getBytes());
            outputStream.flush();
            return;
        }
        if (!axisService.isActive()) {
            response.addHeader("Content-Type", "text/html");
            outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display Schema.</h4>").getBytes());
            outputStream.flush();
            return;
        }
        String uri = request.getQueryString();
        if (request.getQueryString().endsWith(".xsd")) {
            String schemaName = uri.substring(uri.lastIndexOf(61) + 1);
            HashMap services = configCtx.getAxisConfiguration().getServices();
            AxisService service = (AxisService)services.get(serviceName);
            if (service != null) {
                int dotIndex;
                service.populateSchemaMappings();
                Map schemaTable = service.getSchemaMappingTable();
                schema = (XmlSchema)schemaTable.get(schemaName);
                if (schema == null) {
                    int slashIndex = schemaName.lastIndexOf(47);
                    int dotIndex2 = schemaName.lastIndexOf(46);
                    if (slashIndex > 0) {
                        String schemaKey = schemaName.substring(slashIndex + 1, dotIndex2);
                        schema = (XmlSchema)schemaTable.get(schemaKey);
                    }
                }
                if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                    String schemaKey = schemaName.substring(0, dotIndex);
                    schema = (XmlSchema)schemaTable.get(schemaKey);
                }
                if (schema != null) {
                    response.setStatus(200);
                    response.addHeader("Content-Type", "text/xml");
                    schema.write(response.getOutputStream());
                    return;
                }
                InputStream instream = service.getClassLoader().getResourceAsStream("META-INF/" + schemaName);
                if (instream != null) {
                    response.setStatus(200);
                    response.addHeader("Content-Type", "text/xml");
                    OutputStream outstream = response.getOutputStream();
                    boolean checkLength = true;
                    int length = Integer.MAX_VALUE;
                    int nextValue = instream.read();
                    if (checkLength) {
                        --length;
                    }
                    while (-1 != nextValue && length >= 0) {
                        outstream.write(nextValue);
                        nextValue = instream.read();
                        if (!checkLength) continue;
                        --length;
                    }
                    outstream.flush();
                    return;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int ret = service.printXSD((OutputStream)baos, schemaName);
                if (ret > 0) {
                    baos.flush();
                    instream = new ByteArrayInputStream(baos.toByteArray());
                    response.setStatus(200);
                    response.addHeader("Content-Type", "text/xml");
                    OutputStream outstream = response.getOutputStream();
                    boolean checkLength = true;
                    int length = Integer.MAX_VALUE;
                    int nextValue = instream.read();
                    if (checkLength) {
                        --length;
                    }
                    while (-1 != nextValue && length >= 0) {
                        outstream.write(nextValue);
                        nextValue = instream.read();
                        if (!checkLength) continue;
                        --length;
                    }
                    outstream.flush();
                    return;
                }
            }
        }
        axisService.populateSchemaMappings();
        Map schemaMappingtable = axisService.getSchemaMappingTable();
        String xsds = request.getParameter("xsd");
        if (xsds != null && xsds.trim().length() != 0) {
            int dotIndex;
            response.addHeader("Content-Type", "text/xml");
            XmlSchema schema2 = (XmlSchema)schemaMappingtable.get(xsds);
            if (schema2 == null && (dotIndex = xsds.indexOf(46)) > 0) {
                String schemaKey = xsds.substring(0, dotIndex);
                schema2 = (XmlSchema)schemaMappingtable.get(schemaKey);
            }
            if (schema2 != null) {
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");){
                    schema2.write((Writer)outputStreamWriter);
                    outputStream.flush();
                }
            } else if (xsds.endsWith(".xsd") && xsds.indexOf("..") == -1) {
                InputStream in = axisService.getClassLoader().getResourceAsStream("META-INF/" + xsds);
                if (in != null) {
                    outputStream.write(IOUtils.getStreamAsByteArray((InputStream)in));
                    outputStream.flush();
                    outputStream.close();
                } else {
                    response.setError(404);
                }
            } else {
                String msg = "Invalid schema " + xsds + " requested";
                throw new IOException(msg);
            }
            return;
        }
        ArrayList schemas = axisService.getSchema();
        if (schemas.size() == 1) {
            response.addHeader("Content-Type", "text/xml");
            XsdUtil.processSchema((XmlSchema)schemas.get(0), outputStream, contextRoot, request);
        } else {
            String idParam = request.getParameter("id");
            if (idParam != null) {
                schema = axisService.getSchema(Integer.parseInt(idParam));
                if (schema != null) {
                    response.addHeader("Content-Type", "text/xml");
                    XsdUtil.processSchema(schema, outputStream, contextRoot, request);
                } else {
                    response.addHeader("Content-Type", "text/html");
                    outputStream.write("<h4>Schema not found!</h4>".getBytes());
                }
            }
        }
    }

    private static void processSchema(XmlSchema schema, OutputStream outputStream, String contextRoot, CarbonHttpRequest request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write((OutputStream)baos);
        RequestProcessorUtil.writeDocument(baos, outputStream, "annotated-xsd.xsl", contextRoot, XsdUtil.isXSDAnnotated(request));
    }

    private static boolean isXSDAnnotated(CarbonHttpRequest request) {
        String param = request.getParameter("annotation");
        return param != null && param.length() != 0 && param.equals("true");
    }
}

