/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestProcessorUtil {
    private static Log log = LogFactory.getLog(RequestProcessorUtil.class);
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(ByteArrayOutputStream byteArrayOutStream, OutputStream out, String annotatedXsl, String contextRoot, boolean annotation) {
        ByteArrayInputStream bais = null;
        XMLStreamReader reader = null;
        try {
            bais = new ByteArrayInputStream(byteArrayOutStream.toByteArray());
            reader = xmlInputFactory.createXMLStreamReader(bais);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement docElem = builder.getDocumentElement();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            if (annotatedXsl != null && annotation) {
                writer.writeProcessingInstruction("xml-stylesheet", "  type=\"text/xsl\" href=\"" + (contextRoot.equals("/") ? "" : contextRoot) + "/styles/" + annotatedXsl + "\"");
            }
            docElem.serialize(writer);
            writer.flush();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error occurred while trying to write processing instruction for attaching annotated style sheet", (Throwable)e);
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean canExposeServiceMetadata(AxisService service) throws IOException {
        Parameter exposeServiceMetadata = service.getParameter("exposeServiceMetadata");
        return exposeServiceMetadata == null || !JavaUtils.isFalseExplicitly((Object)exposeServiceMetadata.getValue());
    }

    public static String getServiceContextPath(ConfigurationContext configCtx) {
        String serviceContextPath = configCtx.getServiceContextPath();
        if (!configCtx.getContextRoot().equals("/") && !serviceContextPath.startsWith("/")) {
            serviceContextPath = "/" + serviceContextPath;
        }
        return serviceContextPath;
    }

    static {
        try {
            xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Failed to load XML Processor Feature XMLInputFactory.IS_NAMESPACE_AWARE", (Throwable)e);
        }
        try {
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Failed to load XML Processor Feature XMLInputFactory.SUPPORT_DTD", (Throwable)e);
        }
        try {
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Failed to load XML Processor Feature XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES", (Throwable)e);
        }
    }
}

