/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.core.transports.util.RequestProcessorUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class PolicyProcessor
implements HttpGetRequestProcessor {
    @Override
    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configCtx) throws Exception {
        String requestURI = request.getRequestURI();
        String contextPath = configCtx.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        AxisService axisService = configCtx.getAxisConfiguration().getServiceForActivation(serviceName);
        OutputStream outputStream = response.getOutputStream();
        if (axisService != null) {
            if (GhostDeployerUtils.isGhostService((AxisService)axisService)) {
                axisService = GhostDeployerUtils.deployActualService((AxisConfiguration)configCtx.getAxisConfiguration(), (AxisService)axisService);
            }
            if (!axisService.isActive()) {
                response.addHeader("Content-Type", "text/html");
                outputStream.write(("<h4>Service " + serviceName + " is inactive. Cannot display policies.</h4>").getBytes());
                outputStream.flush();
            } else {
                PolicyInclude policyInclude = axisService.getPolicyInclude();
                if (policyInclude == null) {
                    response.addHeader("Content-Type", "text/html");
                    outputStream.write("<h4>Policy element is not found!</h4>".getBytes());
                    outputStream.flush();
                    return;
                }
                ArrayList policyElements = policyInclude.getPolicyElements();
                if (policyElements == null) {
                    response.addHeader("Content-Type", "text/html");
                    outputStream.write("<h4>Policy elements not found!</h4>".getBytes());
                    outputStream.flush();
                    return;
                }
                PolicyRegistry reg = policyInclude.getPolicyRegistry();
                ExternalPolicySerializer serializer = new ExternalPolicySerializer();
                if (configCtx.getAxisConfiguration().getLocalPolicyAssertions() != null) {
                    serializer.setAssertionsToFilter(configCtx.getAxisConfiguration().getLocalPolicyAssertions());
                }
                if (policyElements.size() == 1) {
                    response.addHeader("Content-Type", "text/xml");
                    if (policyElements.get(0) instanceof Policy) {
                        Policy policy = (Policy)policyElements.get(0);
                        serializer.serialize(policy, outputStream);
                    } else if (policyElements.get(0) instanceof PolicyReference) {
                        Policy p;
                        String key = ((PolicyReference)policyElements.get(0)).getURI();
                        if (key.startsWith("#")) {
                            key = key.substring(key.indexOf(35) + 1);
                        }
                        if ((p = reg.lookup(key)) == null) {
                            response.addHeader("Content-Type", "text/html");
                            outputStream.write("<h4>Policy element not found!</h4>".getBytes());
                        } else {
                            serializer.serialize(p, outputStream);
                        }
                    }
                } else {
                    String idParam = request.getParameter("id");
                    if (idParam != null) {
                        Object policyObject = policyElements.get(Integer.parseInt(idParam));
                        if (policyObject != null) {
                            response.addHeader("Content-Type", "text/xml");
                            if (policyObject instanceof Policy) {
                                Policy policy = (Policy)policyObject;
                                serializer.serialize(policy, outputStream);
                            } else if (policyObject instanceof PolicyReference) {
                                Policy p;
                                String key = ((PolicyReference)policyObject).getURI();
                                if (key.startsWith("#")) {
                                    key = key.substring(key.indexOf(35) + 1);
                                }
                                if ((p = reg.lookup(key)) == null) {
                                    response.addHeader("Content-Type", "text/html");
                                    outputStream.write("<h4>Policy element not found!</h4>".getBytes());
                                } else {
                                    serializer.serialize(p, outputStream);
                                }
                            }
                        } else {
                            response.addHeader("Content-Type", "text/html");
                            outputStream.write("<h4>Policy not found!</h4>".getBytes());
                        }
                    } else if (policyElements.size() == 0) {
                        response.addHeader("Content-Type", "text/html");
                        outputStream.write("<h4>Policy not found!</h4>".getBytes());
                    } else {
                        String ipAddress = "http://" + NetworkUtils.getLocalHostname() + ":" + CarbonUtils.getTransportPort((ConfigurationContext)configCtx, (String)"http");
                        ServerConfigurationService serverCofig = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
                        outputStream.write(("<html><head><title>WSO2 Server v" + serverCofig.getFirstProperty("Version") + " Management Console - " + axisService.getName() + " Service Policies</title></head><body><b>Policies for " + axisService.getName() + " service</b><br/><br/>").getBytes());
                        if (policyElements.size() != 0) {
                            String serviceContextPath = RequestProcessorUtil.getServiceContextPath(configCtx);
                            for (int i = 0; i < policyElements.size(); ++i) {
                                String st = "<a href=\"" + ipAddress + serviceContextPath + "/" + axisService.getName() + "?policy&id=" + i + "\">Policy " + i + "</a><br/>";
                                outputStream.write(st.getBytes());
                            }
                        } else {
                            outputStream.write("<h4>No policies found</h4>".getBytes());
                        }
                        outputStream.write("</body></html>".getBytes());
                    }
                }
            }
        } else {
            response.addHeader("Content-Type", "text/html");
            outputStream.write(("<h4>Service " + serviceName + " not found. Cannot display policies.</h4>").getBytes());
            outputStream.flush();
        }
        outputStream.flush();
    }
}

