/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.security;

import java.util.Collections;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.user.api.TenantManager;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonJMXAuthenticator
implements JMXAuthenticator {
    private static Log log = LogFactory.getLog(CarbonJMXAuthenticator.class);
    private static UserRealm userRealm;
    private static final String JMX_MONITOR_ROLE = "monitorRole";
    private static final String JMX_CONTROL_ROLE = "controlRole";
    private static final String UI_EXECUTE = "ui.execute";
    private static final String JMX_USER_READONLY_PERMISSION = "/permission/protected/server-admin/jmx/readonly";
    private static final String JMX_USER_READWRITE_PERMISSION = "/permission/protected/server-admin/jmx/readwrite";
    private static Log audit;

    public static void setUserRealm(UserRealm userRealm) {
        CarbonJMXAuthenticator.userRealm = userRealm;
    }

    @Override
    public Subject authenticate(Object credentials) {
        UserStoreManager authenticator;
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException("Credentials required");
            }
            throw new SecurityException("Credentials should be String[]");
        }
        String[] aCredentials = (String[])credentials;
        if (aCredentials.length < 2) {
            throw new SecurityException("Credentials should have at least username & password");
        }
        String userName = aCredentials[0];
        String password = aCredentials[1];
        try {
            authenticator = userRealm.getUserStoreManager();
        }
        catch (UserStoreException e) {
            String msg = "Cannot get authenticator from Realm";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, e);
        }
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            String domainNameFromUserName = CarbonJMXAuthenticator.extractTenantDomain(userName);
            if (domainNameFromUserName != null && domainNameFromUserName.equals("carbon.super")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication Failure..Provided tenant domain name is reserved..");
                }
                throw new SecurityException("Authentication failed - System error occurred. Tenant domain name is reserved.");
            }
            if (authenticator.authenticate(userName, (Object)password)) {
                RealmService userRealmService = CarbonCoreDataHolder.getInstance().getRealmService();
                TenantManager tenantManager = userRealmService.getTenantManager();
                String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
                int tenantId = tenantManager.getTenantId(tenantDomain);
                carbonContext.setTenantId(tenantId);
                carbonContext.setTenantDomain(tenantDomain);
                audit.info((Object)("User " + userName + " successfully authenticated to perform JMX operations."));
                return new Subject(true, Collections.singleton(new JMXPrincipal(this.authorize(userName))), Collections.EMPTY_SET, Collections.EMPTY_SET);
            }
            throw new SecurityException("Login failed for user : " + userName + ". Invalid username or password.");
        }
        catch (SecurityException se) {
            String msg = "Unauthorized access attempt to JMX operation. ";
            audit.warn((Object)msg, (Throwable)se);
            throw new SecurityException(msg, se);
        }
        catch (Exception e) {
            String msg = "JMX operation failed.";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, e);
        }
    }

    private String authorize(String userName) throws UserStoreException {
        AuthorizationManager authorizationManager = userRealm.getAuthorizationManager();
        String roleName = null;
        if (authorizationManager != null) {
            if (authorizationManager.isUserAuthorized(userName, JMX_USER_READWRITE_PERMISSION, UI_EXECUTE)) {
                roleName = JMX_CONTROL_ROLE;
            } else if (authorizationManager.isUserAuthorized(userName, JMX_USER_READONLY_PERMISSION, UI_EXECUTE)) {
                roleName = JMX_MONITOR_ROLE;
            }
            if (roleName != null) {
                audit.info((Object)("User: " + userName + " successfully authorized as " + roleName + " to perform JMX operations."));
                return roleName;
            }
            throw new SecurityException("User: " + userName + " not authorized to perform JMX operations.");
        }
        throw new UserStoreException("Unable to retrieve Authorization manager to perform authorization");
    }

    public static String extractTenantDomain(String userName) {
        if (userName.contains("@")) {
            return userName.substring(userName.lastIndexOf(64) + 1);
        }
        return null;
    }

    static {
        audit = CarbonConstants.AUDIT_LOG;
    }
}

