/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadata;
import org.wso2.carbon.core.persistence.metadata.ArtifactMetadataException;
import org.wso2.carbon.core.persistence.metadata.ArtifactType;
import org.xml.sax.InputSource;

@Deprecated
public class ArtifactMetadataManager {
    private static final Log log = LogFactory.getLog(ArtifactMetadataManager.class);
    private String deploymentRepoPath;
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public ArtifactMetadataManager(AxisConfiguration axisConfig) throws ArtifactMetadataException {
        try {
            URL repositoryURL = axisConfig.getRepository();
            if (repositoryURL != null) {
                this.deploymentRepoPath = URLDecoder.decode(axisConfig.getRepository().getPath(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Metafiles directory URL can not be decoded. " + axisConfig.getRepository()), (Throwable)e);
            throw new ArtifactMetadataException(e.getMessage(), e);
        }
    }

    public boolean isMetafileExists(String artifactName, ArtifactType artifactType) {
        File metadataFile = this.calculateMetafilePath(artifactName, artifactType);
        return metadataFile.exists();
    }

    public void deleteMetafile(String artifactName, ArtifactType artifactType) {
        File metadataFile = this.calculateMetafilePath(artifactName, artifactType);
        if (metadataFile.exists() && !metadataFile.delete()) {
            metadataFile.deleteOnExit();
        }
    }

    public ArtifactMetadata loadParameters(String artifactName, ArtifactType artifactType) throws ArtifactMetadataException {
        File metadataFile = this.calculateMetafilePath(artifactName, artifactType);
        Properties prop = this.loadParameters(metadataFile.getAbsolutePath());
        ArtifactMetadata metadataObject = new ArtifactMetadata(artifactName, artifactType, metadataFile);
        metadataObject.setProperties(prop);
        return metadataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadParameters(String absolutePath) throws ArtifactMetadataException {
        File metadataFile = new File(absolutePath);
        FileInputStream fis = null;
        try {
            if (metadataFile.exists()) {
                fis = FileUtils.openInputStream((File)metadataFile);
                Properties properties = new Properties();
                properties.load(fis);
                Properties properties2 = properties;
                return properties2;
            }
            Properties properties = new Properties();
            return properties;
        }
        catch (IOException e) {
            this.handleException(e.getMessage(), e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveParameters(ArtifactMetadata metadataObject) throws ArtifactMetadataException {
        boolean created;
        FileOutputStream fileOutputStream = null;
        File file = metadataObject.getFile();
        if (!file.getParentFile().exists() && !(created = file.getParentFile().mkdirs())) {
            throw new ArtifactMetadataException("Unable to create directory structure for persisting metafiles" + file.getPath());
        }
        String comment = metadataObject.getArtifactName() + "@@@" + metadataObject.getArtifactType();
        try {
            fileOutputStream = FileUtils.openOutputStream((File)file);
            metadataObject.getProperties().store(fileOutputStream, "UTF-8");
        }
        catch (FileNotFoundException e) {
            this.handleException("File can not be opened for writing. " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.handleException(" Error while saving artifact metafiles for " + metadataObject.getArtifactName() + ". " + e.getMessage(), e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public String loadParameter(String artifactName, ArtifactType artifactType, String propertyName) throws ArtifactMetadataException {
        ArtifactMetadata metadataObject = this.loadParameters(artifactName, artifactType);
        return metadataObject.getProperties().getProperty(propertyName);
    }

    public Element loadXMLParameter(String artifactName, ArtifactType artifactType, String propertyName) throws ArtifactMetadataException {
        try {
            String param = this.loadParameter(artifactName, artifactType, propertyName);
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(param));
            DocumentBuilderFactory dbf = ArtifactMetadataManager.getSecuredDocumentBuilder();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(is);
            return d.getDocumentElement();
        }
        catch (Exception e) {
            String message = "Error while loading parameter as XML. artifact - " + artifactName + ", property - " + propertyName;
            this.handleException(message, e);
            return null;
        }
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public void setParameter(String artifactName, ArtifactType artifactType, String propertyName, String propertyValue, boolean replace) throws ArtifactMetadataException {
        ArtifactMetadata metadataObject = this.loadParameters(artifactName, artifactType);
        Properties prop = metadataObject.getProperties();
        if (replace || prop.get(propertyName) == null) {
            prop.setProperty(propertyName, propertyValue);
            this.saveParameters(metadataObject);
        }
    }

    public void setParameters(String artifactName, ArtifactType artifactType, Properties properties) throws ArtifactMetadataException {
        ArtifactMetadata metadataObject = this.loadParameters(artifactName, artifactType);
        Properties prop = metadataObject.getProperties();
        Set<String> stringPropNames = properties.stringPropertyNames();
        for (String name : stringPropNames) {
            prop.setProperty(name, properties.getProperty(name));
        }
        this.saveParameters(metadataObject);
    }

    public void removeParameter(String artifactName, ArtifactType artifactType, String propertyName) throws ArtifactMetadataException {
        ArtifactMetadata metadataObject = this.loadParameters(artifactName, artifactType);
        Properties prop = metadataObject.getProperties();
        prop.remove(propertyName);
        this.saveParameters(metadataObject);
    }

    private File calculateMetafilePath(String artifactName, ArtifactType artifactType) {
        String metaArtifactDirectoryName = artifactType.getMetadataDirName();
        artifactName = this.getFilePathFromResourceId(artifactName);
        String artifactPath = this.deploymentRepoPath + File.separator + metaArtifactDirectoryName + File.separator + artifactName;
        return new File(artifactPath);
    }

    protected String getFilePathFromResourceId(String resourceId) {
        if (resourceId != null) {
            String[] names = resourceId.split("/");
            StringBuilder sb = new StringBuilder(names[0]);
            char fs = File.separatorChar;
            for (int i = 1; i < names.length; ++i) {
                sb.append(fs).append(names[i]);
            }
            return sb.append(".properties").toString();
        }
        return null;
    }

    private void handleException(String message, Exception e) throws ArtifactMetadataException {
        log.error((Object)message, (Throwable)e);
        throw new ArtifactMetadataException(message, e);
    }
}

