/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.file.ResourceFileData;

@Deprecated
public abstract class AbstractFilePersistenceManager {
    protected AxisConfiguration axisConfig;
    Map<String, ResourceFileData> resourceMap = new HashMap<String, ResourceFileData>();
    private Set<String> userModifiedItems = new HashSet<String>();
    private Set<String> modifyingMetaFiles = new HashSet<String>();
    protected OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private static final Log log = LogFactory.getLog(AbstractFilePersistenceManager.class);

    protected AbstractFilePersistenceManager(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public abstract void beginTransaction(String var1) throws IOException, XMLStreamException, PersistenceException;

    public synchronized void commitTransaction(String resourceId) throws PersistenceException {
    }

    protected String getFilePathFromResourceId(String resourceId) {
        if (resourceId != null) {
            String[] names = resourceId.split("/");
            StringBuilder sb = new StringBuilder(names[0]);
            char fs = File.separatorChar;
            for (int i = 1; i < names.length; ++i) {
                sb.append(fs).append(names[i]);
            }
            return sb.append(".xml").toString();
        }
        return null;
    }

    public void rollbackTransaction(String resourceId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rollbackTransaction for : " + resourceId));
        }
        this.isMetaFileModification(resourceId);
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        if (fileData != null) {
            fileData.setOMElement(null);
            fileData.setTransactionStarted(false);
        }
    }

    public abstract OMElement get(String var1) throws PersistenceDataNotFoundException;

    public OMNode get(String resourceId, String xpathStr) throws PersistenceDataNotFoundException {
        List list = this.getAll(resourceId, xpathStr);
        if (list.size() > 0) {
            return (OMNode)list.get(0);
        }
        return null;
    }

    public OMAttribute getAttribute(String resourceId, String xpathStr) throws PersistenceDataNotFoundException {
        List list = this.getAll(resourceId, xpathStr);
        if (list.size() > 0) {
            return (OMAttribute)list.get(0);
        }
        return null;
    }

    public void put(String resourceName, OMElement content, String xpathOfParent) throws PersistenceDataNotFoundException {
        block8: {
            try {
                ResourceFileData fileData = this.resourceMap.get(resourceName);
                if (fileData != null) {
                    AXIOMXPath xpathExpr = new AXIOMXPath(xpathOfParent);
                    OMElement sgElement = fileData.getOMElement();
                    OMElement parent = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
                    if (parent != null) {
                        if (!parent.equals(content.getParent())) {
                            parent.addChild((OMNode)content);
                            this.setMetaFileModification(resourceName);
                        } else {
                            this.setMetaFileModification(resourceName);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Trying add a child to the same parent. " + resourceName + content.toString()));
                            }
                        }
                        break block8;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("parent can not be found - " + resourceName + fileData.getOMElement()));
                    }
                    throw new PersistenceDataNotFoundException("The resource can not be added because Parent could not be found." + resourceName + " The XPath - " + xpathOfParent);
                }
                throw new PersistenceDataNotFoundException("ResourceFileData not found. The Transaction May not have been initialized. see #beginTransaction. " + resourceName + "The xpath used was " + xpathOfParent);
            }
            catch (JaxenException e) {
                log.error((Object)("Error selecting parent in " + resourceName), (Throwable)e);
                throw new PersistenceDataNotFoundException("Error selecting parent in " + resourceName, e);
            }
        }
    }

    public void put(String resourceName, OMAttribute attr, String xpathOfElement) throws PersistenceDataNotFoundException {
        try {
            ResourceFileData fileData = this.resourceMap.get(resourceName);
            if (fileData == null) {
                log.error((Object)("put attr = " + attr.getAttributeType() + attr.getAttributeValue()));
                throw new PersistenceDataNotFoundException("ResourceFileData not found. The Transaction May not have been initialized. see #beginTransaction. " + resourceName + "The xpath used was " + xpathOfElement);
            }
            OMElement sgElement = fileData.getOMElement();
            AXIOMXPath xpathExpr = new AXIOMXPath(xpathOfElement);
            OMElement parent = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
            parent.addAttribute(attr);
            this.setMetaFileModification(resourceName);
        }
        catch (JaxenException e) {
            log.error((Object)("XPath syntaxt error " + xpathOfElement), (Throwable)e);
            throw new PersistenceDataNotFoundException("XPath syntaxt error for " + resourceName + xpathOfElement, e);
        }
    }

    public boolean fileExists(String resourceId) {
        return true;
    }

    public boolean elementExists(String resourceId, String elementXpathStr) {
        return false;
    }

    public List getAll(String resourceId, String xpathStr) throws PersistenceDataNotFoundException {
        return new ArrayList(0);
    }

    public boolean delete(String resourceId, String xpathStr) {
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        try {
            if (fileData != null && fileData.isTransactionStarted()) {
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                OMElement sgElement = fileData.getOMElement();
                OMElement el = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
                if (el == null) {
                    return false;
                }
                if (el.getParent() == null) {
                    fileData.setOMElement(null);
                } else {
                    el.detach();
                }
                this.setMetaFileModification(resourceId);
                return true;
            }
            log.error((Object)("The Element specified by path not found or a transaction isn't started yet. " + xpathStr));
            return false;
        }
        catch (JaxenException e) {
            log.error((Object)("Error parsing xpath string " + resourceId + xpathStr), (Throwable)e);
            return false;
        }
    }

    public boolean deleteAll(String resourceId, String xpathStr) {
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        try {
            if (fileData != null && fileData.isTransactionStarted()) {
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                OMElement sgElement = fileData.getOMElement();
                List nodeList = xpathExpr.selectNodes((Object)sgElement);
                if (nodeList == null || nodeList.isEmpty()) {
                    return false;
                }
                for (Object obj : nodeList) {
                    OMElement el = (OMElement)obj;
                    if (el.getParent() == null) {
                        fileData.setOMElement(null);
                        continue;
                    }
                    el.detach();
                }
                this.setMetaFileModification(resourceId);
                return true;
            }
            log.error((Object)("The Element specified by path not found or a transaction isn't started yet. " + xpathStr));
        }
        catch (JaxenException e) {
            log.error((Object)("Error parsing xpath string " + resourceId + xpathStr), (Throwable)e);
        }
        return false;
    }

    protected void handleExceptionWithRollback(String resourceId, String msg, Throwable e) throws PersistenceException {
        log.error((Object)msg, e);
        this.rollbackTransaction(resourceId);
        throw new PersistenceException(msg, e);
    }

    protected void handleException(String msg, Throwable e) throws PersistenceException {
        log.error((Object)msg, e);
        throw new PersistenceException(msg, e);
    }

    protected void handleException(String msg) throws PersistenceException {
        log.error((Object)msg);
        throw new PersistenceException(msg);
    }

    public boolean isTransactionStarted(String resourceId) {
        return this.resourceMap.get(resourceId) != null && this.resourceMap.get(resourceId).isTransactionStarted();
    }

    public void init() {
    }

    public boolean isUserModification(String name) {
        return this.userModifiedItems.remove(name);
    }

    public boolean setUserModification(String name) {
        return this.userModifiedItems.add(name);
    }

    protected boolean isMetaFileModification(String resourceId) {
        return this.modifyingMetaFiles.remove(resourceId);
    }

    public void setMetaFileModification(String resourceId) {
        this.modifyingMetaFiles.add(resourceId);
    }
}

