/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.persistence.AbstractPersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.utils.CarbonUtils;

@Deprecated
public class ServiceGroupPersistenceManager
extends AbstractPersistenceManager {
    private static final Log log = LogFactory.getLog(ServiceGroupPersistenceManager.class);

    public ServiceGroupPersistenceManager(AxisConfiguration axisConfig, PersistenceFactory pf) throws AxisFault {
        super(axisConfig, pf.getServiceGroupFilePM(), pf);
    }

    public ServiceGroupPersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        super(axisConfig);
        try {
            if (this.pf == null) {
                this.pf = PersistenceFactory.getInstance(axisConfig);
            }
            this.fpm = this.pf.getServiceGroupFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error getting PersistenceFactory instance", (Throwable)e);
        }
    }

    public OMElement getServiceGroup(String serviceGroupId) throws Exception {
        try {
            if (this.getServiceGroupFilePM().fileExists(serviceGroupId)) {
                OMElement sgElement = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, "/");
                if (this.getServiceGroupFilePM().getAttribute(serviceGroupId, "/@successfullyAdded") != null) {
                    return sgElement;
                }
            }
        }
        catch (Throwable e) {
            this.handleException("Could not get the Service Group resource", e);
        }
        return null;
    }

    public void deleteServiceGroup(AxisServiceGroup serviceGroup) throws Exception {
        Iterator services = serviceGroup.getServices();
        Parameter param = serviceGroup.getParameter("preserveServiceHistory");
        if (services.hasNext() && ((AxisService)services.next()).isClientSide()) {
            return;
        }
        try {
            if (param == null || !JavaUtils.isTrue((String)param.getValue().toString())) {
                this.removeResource(serviceGroup.getServiceGroupName(), "/");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully deleted resource for " + serviceGroup.getServiceGroupName() + " Service Group"));
                }
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(serviceGroup.getServiceGroupName(), "Could not delete Service Group resource from Config Registry", e);
        }
    }

    public void engageModuleForServiceGroup(AxisModule module, AxisServiceGroup serviceGroup) throws Exception {
        try {
            this.handleModuleForAxisDescription(serviceGroup.getServiceGroupName(), module, "/", true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully engaged " + module.getName() + " module to " + serviceGroup.getServiceGroupName() + " service group "));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to engage " + module.getName() + " module to " + serviceGroup.getServiceGroupName() + " service group ", e);
        }
    }

    public void disengageModuleForServiceGroup(AxisModule module, AxisServiceGroup serviceGroup) throws Exception {
        try {
            this.handleModuleForAxisDescription(serviceGroup.getServiceGroupName(), module, "/", false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully disengaged " + module.getName() + " module from " + serviceGroup.getServiceGroupName() + " service group "));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to disengage " + module.getName() + " module from " + serviceGroup.getServiceGroupName() + " service group ", e);
        }
    }

    public void handleExistingServiceGroupInit(AxisServiceGroup serviceGroup) throws Exception {
        String serviceGroupId = serviceGroup.getServiceGroupName();
        try {
            boolean isTransactionStarted = this.getServiceGroupFilePM().isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.getServiceGroupFilePM().beginTransaction(serviceGroupId);
            }
            this.loadParameters(serviceGroupId, (AxisDescription)serviceGroup, "/parameter");
            serviceGroup.getEngagedModules().clear();
            List moduleList = this.getServiceGroupFilePM().getAll(serviceGroupId, "/module");
            for (Object node : moduleList) {
                OMElement moduleElement = (OMElement)node;
                String name = moduleElement.getAttributeValue(new QName("name"));
                String version = moduleElement.getAttributeValue(new QName("version"));
                AxisModule axisModule = this.getExistingAxisModule(name, version);
                if (this.isGloballyEngaged(name, version)) continue;
                serviceGroup.disengageModule(axisModule);
                serviceGroup.engageModule(axisModule);
            }
            if (!isTransactionStarted) {
                this.getServiceGroupFilePM().commitTransaction(serviceGroupId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized Service Group - " + serviceGroup.getServiceGroupName()));
            }
        }
        catch (Throwable e) {
            log.error((Object)("unable init. " + this.getCurrentFPM().get(serviceGroupId)), e);
            this.handleExceptionWithRollback(serviceGroupId, "Unable to handle service group init. Service group: " + serviceGroupId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewServiceGroupAddition(AxisServiceGroup serviceGroup) throws Exception {
        Iterator services = serviceGroup.getServices();
        if (services.hasNext() && ((AxisService)services.next()).isClientSide()) {
            return;
        }
        Object object = WRITE_LOCK;
        synchronized (object) {
            String sgName = serviceGroup.getServiceGroupName();
            try {
                this.getServiceGroupFilePM().beginTransaction(sgName);
                OMAttribute nameAttr = this.omFactory.createOMAttribute("name", null, sgName);
                this.getServiceGroupFilePM().put(sgName, nameAttr, "/");
                String hashValue = CarbonUtils.computeServiceHash((AxisServiceGroup)serviceGroup);
                if (hashValue != null) {
                    OMAttribute hashAttr = this.omFactory.createOMAttribute("hashValue", null, hashValue);
                    this.getServiceGroupFilePM().put(sgName, hashAttr, "/");
                }
                for (Object o : serviceGroup.getEngagedModules()) {
                    AxisModule axisModule = (AxisModule)o;
                    if (this.axisConfig.isEngaged(axisModule.getName())) continue;
                    String version = PersistenceUtils.getModuleVersion(axisModule);
                    OMElement module = PersistenceUtils.createModule(axisModule.getName(), version, "engagedModules");
                    this.getServiceGroupFilePM().put(sgName, module, "/");
                }
                this.writeParameters(sgName, serviceGroup.getParameters(), "/");
                this.getServiceGroupFilePM().put(sgName, this.omFactory.createOMAttribute("successfullyAdded", null, "true"), "/");
                this.getServiceGroupFilePM().commitTransaction(sgName);
            }
            catch (IOException ex) {
                log.error((Object)"unable to handle new service addition. ", (Throwable)ex);
            }
            catch (Throwable e) {
                log.error((Object)("unable to handle new service addition. " + serviceGroup.getServiceGroupName()), e);
                this.handleExceptionWithRollback(sgName, "Unable to handle new service group addition. Service group: " + serviceGroup.getServiceGroupName(), e);
            }
        }
    }

    public void setServiceGroupProperty(AxisServiceGroup serviceGroup, String propertyName, String propertyValue) throws Exception {
        String sgId = serviceGroup.getServiceGroupName();
        try {
            OMAttribute prop = this.omFactory.createOMAttribute(propertyName, null, propertyValue);
            this.getServiceGroupFilePM().beginTransaction(sgId);
            if (this.getServiceGroupFilePM().fileExists(sgId)) {
                this.getServiceGroupFilePM().put(sgId, prop, "/");
            }
            this.getServiceGroupFilePM().commitTransaction(sgId);
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(sgId, "Unable to set property " + propertyName + " to service group " + serviceGroup.getServiceGroupName(), e);
        }
    }

    public void updateServiceGroupParameter(AxisServiceGroup serviceGroup, Parameter parameter) throws Exception {
        try {
            this.updateParameter(serviceGroup.getServiceGroupName(), parameter, "/");
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(serviceGroup.getServiceGroupName(), "Unable to update the service group parameter " + parameter.getName() + " of service group " + serviceGroup.getServiceGroupName(), e);
        }
    }
}

