/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.TenantAxisConfigurator;
import org.wso2.carbon.core.multitenancy.transports.DummyTransportListener;
import org.wso2.carbon.core.multitenancy.transports.TenantTransportInDescription;
import org.wso2.carbon.core.multitenancy.transports.TenantTransportSender;
import org.wso2.carbon.core.util.Utils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public final class TenantAxisUtils {
    private static final Log log = LogFactory.getLog(TenantAxisUtils.class);
    private static final String TENANT_CONFIGURATION_CONTEXTS = "tenant.config.contexts";
    private static final String TENANT_CONFIGURATION_CONTEXTS_CREATED = "tenant.config.contexts.created";
    private static CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private static Map<String, ReentrantReadWriteLock> tenantReadWriteLocks = new ConcurrentHashMap<String, ReentrantReadWriteLock>();

    private TenantAxisUtils() {
    }

    public static int getTenantId(ConfigurationContext configCtx) {
        return MultitenantUtils.getTenantId((ConfigurationContext)configCtx);
    }

    public static AxisConfiguration getTenantAxisConfiguration(String tenant, ConfigurationContext mainConfigCtx) {
        ConfigurationContext tenantConfigCtx = TenantAxisUtils.getTenantConfigurationContext(tenant, mainConfigCtx);
        if (tenantConfigCtx != null) {
            return tenantConfigCtx.getAxisConfiguration();
        }
        return null;
    }

    public static ConfigurationContext getTenantConfigurationContextFromUrl(String url, ConfigurationContext mainConfigCtx) {
        String tenantDomain = MultitenantUtils.getTenantDomainFromUrl((String)url);
        return TenantAxisUtils.getTenantConfigurationContext(tenantDomain, mainConfigCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationContext getTenantConfigurationContext(String tenantDomain, ConfigurationContext mainConfigCtx) {
        ConfigurationContext tenantConfigCtx;
        Boolean isTenantActive;
        try {
            isTenantActive = CarbonCoreDataHolder.getInstance().getRealmService().getTenantManager().isTenantActive(TenantAxisUtils.getTenantId(tenantDomain));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting tenant activation status.", e);
        }
        if (!isTenantActive.booleanValue()) {
            throw new RuntimeException("Trying to access inactive tenant domain : " + tenantDomain);
        }
        if (tenantReadWriteLocks.get(tenantDomain) == null) {
            String e = tenantDomain.intern();
            synchronized (e) {
                if (tenantReadWriteLocks.get(tenantDomain) == null) {
                    tenantReadWriteLocks.put(tenantDomain, new ReentrantReadWriteLock());
                }
            }
        }
        ReentrantReadWriteLock.ReadLock tenantReadLock = tenantReadWriteLocks.get(tenantDomain).readLock();
        try {
            tenantReadLock.lock();
            Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainConfigCtx);
            tenantConfigCtx = tenantConfigContexts.get(tenantDomain);
            if (tenantConfigCtx == null) {
                try {
                    tenantConfigCtx = TenantAxisUtils.createTenantConfigurationContext(mainConfigCtx, tenantDomain);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot create tenant ConfigurationContext for tenant " + tenantDomain, e);
                }
            }
            tenantConfigCtx.setProperty("last.accessed.time", (Object)System.currentTimeMillis());
        }
        finally {
            tenantReadLock.unlock();
        }
        return tenantConfigCtx;
    }

    public static long getLastAccessed(String tenantDomain, ConfigurationContext mainConfigCtx) {
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainConfigCtx);
        ConfigurationContext tenantConfigCtx = tenantConfigContexts.get(tenantDomain);
        if (tenantConfigCtx != null) {
            Long lastAccessed = (Long)tenantConfigCtx.getProperty("last.accessed.time");
            return lastAccessed == null ? -1L : lastAccessed;
        }
        return -1L;
    }

    public static void setTenantAccessed(String tenantDomain, ConfigurationContext mainConfigCtx) {
        TenantAxisUtils.getTenantConfigurationContext(tenantDomain, mainConfigCtx);
    }

    public static AxisService getAxisService(String url, ConfigurationContext mainConfigContext) throws AxisFault {
        String[] strings = url.split("/");
        boolean foundTenantDelimiter = false;
        String tenant = null;
        String service = null;
        for (String str : strings) {
            if (!foundTenantDelimiter && str.equals("t")) {
                foundTenantDelimiter = true;
                continue;
            }
            if (foundTenantDelimiter & tenant == null) {
                tenant = str;
                continue;
            }
            if (tenant == null) continue;
            service = service == null ? str : service + "/" + str;
        }
        if (service != null) {
            service = service.split("\\?")[0];
            AxisConfiguration tenantAxisConfig = TenantAxisUtils.getTenantAxisConfiguration(tenant, mainConfigContext);
            if (tenantAxisConfig != null) {
                return tenantAxisConfig.getServiceForActivation(service);
            }
        }
        return null;
    }

    public static Map<String, ConfigurationContext> getTenantConfigurationContexts(ConfigurationContext mainConfigCtx) {
        ConcurrentHashMap tenantConfigContexts = (ConcurrentHashMap)mainConfigCtx.getProperty(TENANT_CONFIGURATION_CONTEXTS);
        if (tenantConfigContexts == null) {
            tenantConfigContexts = new ConcurrentHashMap();
            mainConfigCtx.setProperty(TENANT_CONFIGURATION_CONTEXTS, tenantConfigContexts);
        }
        return tenantConfigContexts;
    }

    public static void initializeTenantTransports(ConfigurationContext mainConfigCtx) throws AxisFault {
        AxisConfiguration mainAxisConfig = mainConfigCtx.getAxisConfiguration();
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainConfigCtx);
        if (tenantConfigContexts != null) {
            for (Map.Entry<String, ConfigurationContext> entry : tenantConfigContexts.entrySet()) {
                String tenantDomain = entry.getKey();
                ConfigurationContext tenantConfigCtx = entry.getValue();
                AxisConfiguration tenantAxisConfig = tenantConfigCtx.getAxisConfiguration();
                TenantAxisUtils.setTenantTransports(mainAxisConfig, tenantDomain, tenantAxisConfig);
            }
        }
    }

    public static void setTenantTransports(AxisConfiguration mainAxisConfig, String tenantDomain, AxisConfiguration tenantAxisConfig) throws AxisFault {
        for (String transport : mainAxisConfig.getTransportsIn().keySet()) {
            TenantTransportInDescription tenantTransportIn = new TenantTransportInDescription(transport);
            tenantTransportIn.setMainTransportInDescription((TransportInDescription)mainAxisConfig.getTransportsIn().get(transport));
            TransportListener mainTransportListener = mainAxisConfig.getTransportIn(transport).getReceiver();
            tenantTransportIn.setReceiver(new DummyTransportListener(mainTransportListener, tenantDomain));
            tenantAxisConfig.addTransportIn((TransportInDescription)tenantTransportIn);
        }
    }

    private static ConfigurationContext createTenantConfigurationContext(ConfigurationContext mainConfigCtx, String tenantDomain) throws Exception {
        String lockedDomain = tenantDomain + "@TenantAxisUtils_createTenantConfigurationContext";
        String string = lockedDomain.intern();
        synchronized (string) {
            Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainConfigCtx);
            ConfigurationContext tenantConfigCtx = tenantConfigContexts.get(tenantDomain);
            if (tenantConfigCtx != null) {
                return tenantConfigCtx;
            }
            long tenantLoadingStartTime = System.currentTimeMillis();
            int tenantId = TenantAxisUtils.getTenantId(tenantDomain);
            if (tenantId == -1234 || tenantId == -1) {
                throw new Exception("Tenant " + tenantDomain + " does not exist");
            }
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(tenantId);
            carbonContext.setTenantDomain(tenantDomain);
            tenantConfigCtx = tenantConfigContexts.get(tenantDomain);
            if (tenantConfigCtx != null) {
                return tenantConfigCtx;
            }
            AxisConfiguration mainAxisConfig = mainConfigCtx.getAxisConfiguration();
            dataHolder.getTenantRegistryLoader().loadTenantRegistry(tenantId);
            try {
                UserRegistry tenantConfigRegistry = dataHolder.getRegistryService().getConfigSystemRegistry(tenantId);
                UserRegistry tenantLocalUserRegistry = dataHolder.getRegistryService().getLocalRepository(tenantId);
                TenantAxisConfigurator tenantAxisConfigurator = new TenantAxisConfigurator(mainAxisConfig, tenantDomain, tenantId, tenantConfigRegistry, tenantLocalUserRegistry);
                TenantAxisUtils.doPreConfigContextCreation(tenantId);
                tenantConfigCtx = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)tenantAxisConfigurator);
                AxisConfiguration tenantAxisConfig = tenantConfigCtx.getAxisConfiguration();
                tenantConfigCtx.setServicePath(CarbonUtils.getAxis2ServicesDir((AxisConfiguration)tenantAxisConfig));
                tenantConfigCtx.setContextRoot("local:/");
                TenantTransportSender transportSender = new TenantTransportSender(mainConfigCtx);
                HashMap transportSenders = mainAxisConfig.getTransportsOut();
                if (transportSenders != null && !transportSenders.isEmpty()) {
                    for (String strTransport : transportSenders.keySet()) {
                        TransportOutDescription outDescription = new TransportOutDescription(strTransport);
                        outDescription.setSender((TransportSender)transportSender);
                        tenantAxisConfig.addTransportOut(outDescription);
                    }
                }
                tenantConfigCtx.setProperty("WORK_DIR", mainConfigCtx.getProperty("WORK_DIR"));
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
                BundleContext bundleContext = dataHolder.getBundleContext();
                if (bundleContext != null) {
                    ServiceTracker tracker = new ServiceTracker(bundleContext, Axis2ConfigurationContextObserver.class.getName(), null);
                    tracker.open();
                    Object[] services = tracker.getServices();
                    if (services != null) {
                        for (Object service : services) {
                            ((Axis2ConfigurationContextObserver)service).createdConfigurationContext(tenantConfigCtx);
                        }
                    }
                    tracker.close();
                }
                tenantConfigCtx.setProperty("last.accessed.time", (Object)System.currentTimeMillis());
                Utils.addCAppDeployer(tenantAxisConfig);
                tenantAxisConfigurator.deployServices();
                tenantConfigContexts.put(tenantDomain, tenantConfigCtx);
                log.info((Object)("Loaded tenant " + tenantDomain + " in " + (System.currentTimeMillis() - tenantLoadingStartTime) + " ms"));
                return tenantConfigCtx;
            }
            catch (Exception e) {
                String msg = "Error occurred while running deployment for tenant ";
                log.error((Object)(msg + tenantDomain), (Throwable)e);
                throw new Exception(msg, e);
            }
        }
    }

    public static List<Tenant> getActiveTenants(ConfigurationContext mainConfigCtx) throws Exception {
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainConfigCtx);
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        try {
            TenantManager tenantManager = dataHolder.getRealmService().getTenantManager();
            for (ConfigurationContext tenantCfgCtx : tenantConfigContexts.values()) {
                Tenant tenant = (Tenant)tenantManager.getTenant(MultitenantUtils.getTenantId((ConfigurationContext)tenantCfgCtx));
                tenants.add(tenant);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while getting active tenant list";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return tenants;
    }

    private static int getTenantId(String tenantDomain) throws Exception {
        return dataHolder.getRealmService().getTenantManager().getTenantId(tenantDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupTenants(long tenantIdleTimeMillis) {
        ConfigurationContext mainServerConfigContext = CarbonCoreDataHolder.getInstance().getMainServerConfigContext();
        if (mainServerConfigContext == null) {
            return;
        }
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainServerConfigContext);
        for (Map.Entry<String, ConfigurationContext> entry : tenantConfigContexts.entrySet()) {
            String tenantDomain = entry.getKey();
            String string = tenantDomain.intern();
            synchronized (string) {
                block12: {
                    ConfigurationContext tenantCfgCtx = entry.getValue();
                    Long lastAccessed = (Long)tenantCfgCtx.getProperty("last.accessed.time");
                    if (System.currentTimeMillis() - lastAccessed >= tenantIdleTimeMillis) {
                        ReentrantReadWriteLock.WriteLock tenantWriteLock = tenantReadWriteLocks.get(tenantDomain).writeLock();
                        tenantWriteLock.lock();
                        try {
                            lastAccessed = (Long)tenantCfgCtx.getProperty("last.accessed.time");
                            if (System.currentTimeMillis() - lastAccessed < tenantIdleTimeMillis) break block12;
                            try {
                                PrivilegedCarbonContext.startTenantFlow();
                                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                                carbonContext.setTenantDomain(tenantDomain, true);
                                TenantAxisUtils.terminateTenantConfigContext(tenantCfgCtx);
                                tenantConfigContexts.remove(tenantDomain);
                            }
                            finally {
                                PrivilegedCarbonContext.endTenantFlow();
                            }
                        }
                        finally {
                            tenantWriteLock.unlock();
                        }
                    }
                }
            }
        }
    }

    public static String getTenantDomain(String url) {
        String[] strings = url.split("/");
        boolean foundTenantDelimiter = false;
        String tenant = null;
        for (String str : strings) {
            if (!foundTenantDelimiter && str.equals("t")) {
                foundTenantDelimiter = true;
                continue;
            }
            if (!foundTenantDelimiter) continue;
            tenant = str;
            break;
        }
        return tenant;
    }

    public static void terminateTenantConfigContext(ConfigurationContext tenantCfgCtx) {
        ConfigurationContext mainServerConfigContext = CarbonCoreDataHolder.getInstance().getMainServerConfigContext();
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(mainServerConfigContext);
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        log.info((Object)("Starting to clean tenant : " + tenantDomain));
        tenantCfgCtx.getAxisConfiguration().getConfigurator().cleanup();
        try {
            TenantAxisUtils.doPreConfigContextTermination(tenantCfgCtx);
            tenantCfgCtx.terminate();
            TenantAxisUtils.doPostConfigContextTermination(tenantCfgCtx);
            tenantConfigContexts.remove(tenantDomain);
            log.info((Object)("Cleaned up tenant " + tenantDomain));
        }
        catch (AxisFault e) {
            log.error((Object)("Cannot cleanup ConfigurationContext of tenant " + tenantDomain), (Throwable)e);
        }
    }

    private static void doPreConfigContextCreation(int tenantId) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, Axis2ConfigurationContextObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((Axis2ConfigurationContextObserver)service).creatingConfigurationContext(tenantId);
                }
            }
            tracker.close();
        }
    }

    private static void doPreConfigContextTermination(ConfigurationContext tenantCfgCtx) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, Axis2ConfigurationContextObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((Axis2ConfigurationContextObserver)service).terminatingConfigurationContext(tenantCfgCtx);
                }
            }
            tracker.close();
        }
    }

    private static void doPostConfigContextTermination(ConfigurationContext tenantCfgCtx) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, Axis2ConfigurationContextObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((Axis2ConfigurationContextObserver)service).terminatedConfigurationContext(tenantCfgCtx);
                }
            }
            tracker.close();
        }
    }
}

